/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.reindex;

import conductor.org.elasticsearch.action.GenericAction;
import conductor.org.elasticsearch.action.search.SearchRequest;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentFactory;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.index.reindex.AbstractBaseReindexRestHandler;
import conductor.org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import conductor.org.elasticsearch.index.reindex.BulkByScrollResponse;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.action.search.RestSearchAction;
import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;

public abstract class AbstractBulkByQueryRestHandler<Request extends AbstractBulkByScrollRequest<Request>, A extends GenericAction<Request, BulkByScrollResponse>>
extends AbstractBaseReindexRestHandler<Request, A> {
    protected AbstractBulkByQueryRestHandler(Settings settings, A action) {
        super(settings, action);
    }

    protected void parseInternalRequest(Request internal, RestRequest restRequest, Map<String, Consumer<Object>> bodyConsumers) throws IOException {
        assert (internal != null) : "Request should not be null";
        assert (restRequest != null) : "RestRequest should not be null";
        SearchRequest searchRequest = ((AbstractBulkByScrollRequest)internal).getSearchRequest();
        try (XContentParser parser = this.extractRequestSpecificFields(restRequest, bodyConsumers);){
            RestSearchAction.parseSearchRequest(searchRequest, restRequest, parser, arg_0 -> internal.setSize(arg_0));
        }
        searchRequest.source().size(restRequest.paramAsInt("scroll_size", searchRequest.source().size()));
        String conflicts = restRequest.param("conflicts");
        if (conflicts != null) {
            ((AbstractBulkByScrollRequest)internal).setConflicts(conflicts);
        }
        if (restRequest.hasParam("search_timeout")) {
            searchRequest.source().timeout(restRequest.paramAsTime("search_timeout", null));
        }
    }

    private XContentParser extractRequestSpecificFields(RestRequest restRequest, Map<String, Consumer<Object>> bodyConsumers) throws IOException {
        if (!restRequest.hasContentOrSourceParam()) {
            return null;
        }
        try (XContentParser parser = restRequest.contentOrSourceParamParser();){
            XContentBuilder builder = XContentFactory.contentBuilder(parser.contentType());
            try {
                Map<String, Object> body = parser.map();
                for (Map.Entry<String, Consumer<Object>> consumer : bodyConsumers.entrySet()) {
                    Object value = body.remove(consumer.getKey());
                    if (value == null) continue;
                    consumer.getValue().accept(value);
                }
                XContentParser xContentParser = parser.contentType().xContent().createParser(parser.getXContentRegistry(), parser.getDeprecationHandler(), BytesReference.bytes(builder.map(body)).streamInput());
                if (builder != null) {
                    builder.close();
                }
                return xContentParser;
            }
            catch (Throwable throwable) {
                if (builder != null) {
                    try {
                        builder.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }
}

