/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.search;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.elasticsearch.ElasticsearchParseException;
import conductor.org.elasticsearch.common.logging.DeprecationLogger;
import conductor.org.elasticsearch.common.regex.Regex;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.index.query.QueryShardContext;
import conductor.org.elasticsearch.index.query.QueryShardException;
import conductor.org.elasticsearch.search.SearchModule;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class QueryParserHelper {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(QueryParserHelper.class));

    private QueryParserHelper() {
    }

    public static Map<String, Float> parseFieldsAndWeights(List<String> fields) {
        HashMap<String, Float> fieldsAndWeights = new HashMap<String, Float>();
        for (String field : fields) {
            String fieldName;
            int boostIndex = field.indexOf(94);
            float boost = 1.0f;
            if (boostIndex != -1) {
                fieldName = field.substring(0, boostIndex);
                boost = Float.parseFloat(field.substring(boostIndex + 1, field.length()));
            } else {
                fieldName = field;
            }
            fieldsAndWeights.put(fieldName, Float.valueOf(boost));
        }
        return fieldsAndWeights;
    }

    public static Map<String, Float> resolveMappingFields(QueryShardContext context, Map<String, Float> fieldsAndWeights) {
        return QueryParserHelper.resolveMappingFields(context, fieldsAndWeights, null);
    }

    public static Map<String, Float> resolveMappingFields(QueryShardContext context, Map<String, Float> fieldsAndWeights, String fieldSuffix) {
        HashMap<String, Float> resolvedFields = new HashMap<String, Float>();
        for (Map.Entry<String, Float> fieldEntry : fieldsAndWeights.entrySet()) {
            boolean allField = Regex.isMatchAllPattern(fieldEntry.getKey());
            boolean multiField = Regex.isSimpleMatchPattern(fieldEntry.getKey());
            float weight = fieldEntry.getValue() == null ? 1.0f : fieldEntry.getValue().floatValue();
            Map<String, Float> fieldMap = QueryParserHelper.resolveMappingField(context, fieldEntry.getKey(), weight, !multiField, !allField, fieldSuffix);
            resolvedFields.putAll(fieldMap);
        }
        QueryParserHelper.checkForTooManyFields(resolvedFields, context);
        return resolvedFields;
    }

    public static Map<String, Float> resolveMappingField(QueryShardContext context, String fieldOrPattern, float weight, boolean acceptAllTypes, boolean acceptMetadataField) {
        return QueryParserHelper.resolveMappingField(context, fieldOrPattern, weight, acceptAllTypes, acceptMetadataField, null);
    }

    public static Map<String, Float> resolveMappingField(QueryShardContext context, String fieldOrPattern, float weight, boolean acceptAllTypes, boolean acceptMetadataField, String fieldSuffix) {
        Collection<String> allFields = context.simpleMatchToIndexNames(fieldOrPattern);
        HashMap<String, Float> fields = new HashMap<String, Float>();
        for (String fieldName : allFields) {
            MappedFieldType fieldType;
            if (fieldSuffix != null && context.fieldMapper(fieldName + fieldSuffix) != null) {
                fieldName = fieldName + fieldSuffix;
            }
            if ((fieldType = context.getMapperService().fullName(fieldName)) == null) {
                fields.put(fieldName, Float.valueOf(weight));
                continue;
            }
            if (!acceptMetadataField && fieldType.name().startsWith("_")) continue;
            if (!acceptAllTypes) {
                try {
                    fieldType.termQuery("", context);
                }
                catch (QueryShardException | UnsupportedOperationException e) {
                    continue;
                }
                catch (ElasticsearchParseException | IllegalArgumentException runtimeException) {
                    // empty catch block
                }
            }
            fields.put(fieldName, Float.valueOf(weight));
        }
        QueryParserHelper.checkForTooManyFields(fields, context);
        return fields;
    }

    private static void checkForTooManyFields(Map<String, Float> fields, QueryShardContext context) {
        Integer limit = SearchModule.INDICES_MAX_CLAUSE_COUNT_SETTING.get(context.getIndexSettings().getSettings());
        if (fields.size() > limit) {
            DEPRECATION_LOGGER.deprecatedAndMaybeLog("field_expansion_limit", "Field expansion matches too many fields, got: {}. This will be limited starting with version 7.0 of Elasticsearch. The limit will be detemined by the `indices.query.bool.max_clause_count` setting which is currently set to {}. You should look at lowering the maximum number of fields targeted by a query or increase the above limit while being aware that this can negatively affect your clusters performance.", fields.size(), limit);
        }
    }
}

