/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.seqno;

import conductor.com.carrotsearch.hppc.LongObjectHashMap;
import conductor.org.elasticsearch.common.SuppressForbidden;
import conductor.org.elasticsearch.index.seqno.CountedBitSet;
import conductor.org.elasticsearch.index.seqno.SeqNoStats;

public class LocalCheckpointTracker {
    static final short BIT_SET_SIZE = 1024;
    final LongObjectHashMap<CountedBitSet> processedSeqNo = new LongObjectHashMap();
    volatile long checkpoint;
    private volatile long nextSeqNo;

    public LocalCheckpointTracker(long maxSeqNo, long localCheckpoint) {
        if (localCheckpoint < 0L && localCheckpoint != -1L) {
            throw new IllegalArgumentException("local checkpoint must be non-negative or [-1] but was [" + localCheckpoint + "]");
        }
        if (maxSeqNo < 0L && maxSeqNo != -1L) {
            throw new IllegalArgumentException("max seq. no. must be non-negative or [-1] but was [" + maxSeqNo + "]");
        }
        this.nextSeqNo = maxSeqNo == -1L ? 0L : maxSeqNo + 1L;
        this.checkpoint = localCheckpoint;
    }

    public synchronized long generateSeqNo() {
        return this.nextSeqNo++;
    }

    public synchronized void advanceMaxSeqNo(long seqNo) {
        if (seqNo >= this.nextSeqNo) {
            this.nextSeqNo = seqNo + 1L;
        }
    }

    public synchronized void markSeqNoAsCompleted(long seqNo) {
        if (seqNo >= this.nextSeqNo) {
            this.nextSeqNo = seqNo + 1L;
        }
        if (seqNo <= this.checkpoint) {
            return;
        }
        CountedBitSet bitSet = this.getBitSetForSeqNo(seqNo);
        int offset = this.seqNoToBitSetOffset(seqNo);
        bitSet.set(offset);
        if (seqNo == this.checkpoint + 1L) {
            this.updateCheckpoint();
        }
    }

    public long getCheckpoint() {
        return this.checkpoint;
    }

    public long getMaxSeqNo() {
        return this.nextSeqNo - 1L;
    }

    public synchronized SeqNoStats getStats(long globalCheckpoint) {
        return new SeqNoStats(this.getMaxSeqNo(), this.getCheckpoint(), globalCheckpoint);
    }

    @SuppressForbidden(reason="Object#wait")
    public synchronized void waitForOpsToComplete(long seqNo) throws InterruptedException {
        while (this.checkpoint < seqNo) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(long seqNo) {
        assert (seqNo >= 0L) : "invalid seq_no=" + seqNo;
        if (seqNo >= this.nextSeqNo) {
            return false;
        }
        if (seqNo <= this.checkpoint) {
            return true;
        }
        long bitSetKey = this.getBitSetKey(seqNo);
        int bitSetOffset = this.seqNoToBitSetOffset(seqNo);
        LocalCheckpointTracker localCheckpointTracker = this;
        synchronized (localCheckpointTracker) {
            CountedBitSet bitSet = this.processedSeqNo.get(bitSetKey);
            return bitSet != null && bitSet.get(bitSetOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="Object#notifyAll")
    private void updateCheckpoint() {
        assert (Thread.holdsLock(this));
        assert (this.getBitSetForSeqNo(this.checkpoint + 1L).get(this.seqNoToBitSetOffset(this.checkpoint + 1L))) : "updateCheckpoint is called but the bit following the checkpoint is not set";
        try {
            long bitSetKey = this.getBitSetKey(this.checkpoint);
            CountedBitSet current = this.processedSeqNo.get(bitSetKey);
            if (current == null) {
                assert (this.checkpoint % 1024L == 1023L);
                current = this.processedSeqNo.get(++bitSetKey);
            }
            do {
                ++this.checkpoint;
                if (this.checkpoint != this.lastSeqNoInBitSet(bitSetKey)) continue;
                assert (current != null);
                CountedBitSet removed = this.processedSeqNo.remove(bitSetKey);
                assert (removed == current);
                current = this.processedSeqNo.get(++bitSetKey);
            } while (current != null && current.get(this.seqNoToBitSetOffset(this.checkpoint + 1L)));
        }
        finally {
            this.notifyAll();
        }
    }

    private long lastSeqNoInBitSet(long bitSetKey) {
        return (1L + bitSetKey) * 1024L - 1L;
    }

    private long getBitSetKey(long seqNo) {
        return seqNo / 1024L;
    }

    private CountedBitSet getBitSetForSeqNo(long seqNo) {
        CountedBitSet bitSet;
        assert (Thread.holdsLock(this));
        long bitSetKey = this.getBitSetKey(seqNo);
        int index = this.processedSeqNo.indexOf(bitSetKey);
        if (this.processedSeqNo.indexExists(index)) {
            bitSet = this.processedSeqNo.indexGet(index);
        } else {
            bitSet = new CountedBitSet(1024);
            this.processedSeqNo.indexInsert(index, bitSetKey, bitSet);
        }
        return bitSet;
    }

    private int seqNoToBitSetOffset(long seqNo) {
        return Math.toIntExact(seqNo % 1024L);
    }
}

