/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.translog;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Streamable;
import conductor.org.elasticsearch.common.unit.ByteSizeValue;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import java.io.IOException;

public class TranslogStats
implements Streamable,
ToXContentFragment {
    private long translogSizeInBytes;
    private int numberOfOperations;
    private long uncommittedSizeInBytes;
    private int uncommittedOperations;
    private long earliestLastModifiedAge;

    public TranslogStats() {
    }

    public TranslogStats(int numberOfOperations, long translogSizeInBytes, int uncommittedOperations, long uncommittedSizeInBytes, long earliestLastModifiedAge) {
        if (numberOfOperations < 0) {
            throw new IllegalArgumentException("numberOfOperations must be >= 0");
        }
        if (translogSizeInBytes < 0L) {
            throw new IllegalArgumentException("translogSizeInBytes must be >= 0");
        }
        if (uncommittedOperations < 0) {
            throw new IllegalArgumentException("uncommittedOperations must be >= 0");
        }
        if (uncommittedSizeInBytes < 0L) {
            throw new IllegalArgumentException("uncommittedSizeInBytes must be >= 0");
        }
        if (earliestLastModifiedAge < 0L) {
            throw new IllegalArgumentException("earliestLastModifiedAge must be >= 0");
        }
        this.numberOfOperations = numberOfOperations;
        this.translogSizeInBytes = translogSizeInBytes;
        this.uncommittedSizeInBytes = uncommittedSizeInBytes;
        this.uncommittedOperations = uncommittedOperations;
        this.earliestLastModifiedAge = earliestLastModifiedAge;
    }

    public void add(TranslogStats translogStats) {
        if (translogStats == null) {
            return;
        }
        this.numberOfOperations += translogStats.numberOfOperations;
        this.translogSizeInBytes += translogStats.translogSizeInBytes;
        this.uncommittedOperations += translogStats.uncommittedOperations;
        this.uncommittedSizeInBytes += translogStats.uncommittedSizeInBytes;
        this.earliestLastModifiedAge = Math.min(this.earliestLastModifiedAge, translogStats.earliestLastModifiedAge);
    }

    public long getTranslogSizeInBytes() {
        return this.translogSizeInBytes;
    }

    public int estimatedNumberOfOperations() {
        return this.numberOfOperations;
    }

    public long getUncommittedSizeInBytes() {
        return this.uncommittedSizeInBytes;
    }

    public int getUncommittedOperations() {
        return this.uncommittedOperations;
    }

    public long getEarliestLastModifiedAge() {
        return this.earliestLastModifiedAge;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("translog");
        builder.field("operations", this.numberOfOperations);
        builder.humanReadableField("size_in_bytes", "size", new ByteSizeValue(this.translogSizeInBytes));
        builder.field("uncommitted_operations", this.uncommittedOperations);
        builder.humanReadableField("uncommitted_size_in_bytes", "uncommitted_size", new ByteSizeValue(this.uncommittedSizeInBytes));
        builder.field("earliest_last_modified_age", this.earliestLastModifiedAge);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.numberOfOperations = in.readVInt();
        this.translogSizeInBytes = in.readVLong();
        if (in.getVersion().onOrAfter(Version.V_6_0_0_beta1)) {
            this.uncommittedOperations = in.readVInt();
            this.uncommittedSizeInBytes = in.readVLong();
        } else {
            this.uncommittedOperations = this.numberOfOperations;
            this.uncommittedSizeInBytes = this.translogSizeInBytes;
        }
        if (in.getVersion().onOrAfter(Version.V_6_3_0)) {
            this.earliestLastModifiedAge = in.readVLong();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.numberOfOperations);
        out.writeVLong(this.translogSizeInBytes);
        if (out.getVersion().onOrAfter(Version.V_6_0_0_beta1)) {
            out.writeVInt(this.uncommittedOperations);
            out.writeVLong(this.uncommittedSizeInBytes);
        }
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            out.writeVLong(this.earliestLastModifiedAge);
        }
    }
}

