/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.translog;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.lucene.index.DirectoryReader;
import conductor.org.apache.lucene.index.IndexCommit;
import conductor.org.apache.lucene.store.Directory;
import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.cli.Terminal;
import conductor.org.elasticsearch.cluster.metadata.IndexMetaData;
import conductor.org.elasticsearch.common.UUIDs;
import conductor.org.elasticsearch.common.collect.Tuple;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.util.BigArrays;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.core.internal.io.IOUtils;
import conductor.org.elasticsearch.index.IndexNotFoundException;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.shard.RemoveCorruptedShardDataCommand;
import conductor.org.elasticsearch.index.shard.ShardPath;
import conductor.org.elasticsearch.index.translog.Checkpoint;
import conductor.org.elasticsearch.index.translog.Translog;
import conductor.org.elasticsearch.index.translog.TranslogConfig;
import conductor.org.elasticsearch.index.translog.TranslogCorruptedException;
import conductor.org.elasticsearch.index.translog.TranslogDeletionPolicy;
import conductor.org.elasticsearch.index.translog.TranslogHeader;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class TruncateTranslogAction {
    protected static final Logger logger = LogManager.getLogger(TruncateTranslogAction.class);
    private final NamedXContentRegistry namedXContentRegistry;

    public TruncateTranslogAction(NamedXContentRegistry namedXContentRegistry) {
        this.namedXContentRegistry = namedXContentRegistry;
    }

    public Tuple<RemoveCorruptedShardDataCommand.CleanStatus, String> getCleanStatus(ShardPath shardPath, Directory indexDirectory) throws IOException {
        Set<Path> translogFiles;
        List<IndexCommit> commits;
        Path indexPath = shardPath.resolveIndex();
        Path translogPath = shardPath.resolveTranslog();
        try {
            commits = DirectoryReader.listCommits(indexDirectory);
        }
        catch (IndexNotFoundException infe) {
            throw new ElasticsearchException("unable to find a valid shard at [" + indexPath + "]", (Throwable)infe, new Object[0]);
        }
        catch (IOException e) {
            throw new ElasticsearchException("unable to list commits at [" + indexPath + "]", (Throwable)e, new Object[0]);
        }
        HashMap<String, String> commitData = new HashMap<String, String>(commits.get(commits.size() - 1).getUserData());
        String translogUUID = (String)commitData.get("translog_uuid");
        if (translogUUID == null) {
            throw new ElasticsearchException("shard must have a valid translog UUID but got: [null]", new Object[0]);
        }
        boolean clean = this.isTranslogClean(shardPath, translogUUID);
        if (clean) {
            return Tuple.tuple(RemoveCorruptedShardDataCommand.CleanStatus.CLEAN, null);
        }
        try {
            translogFiles = TruncateTranslogAction.filesInDirectory(translogPath);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to find existing translog files", (Throwable)e, new Object[0]);
        }
        String details = this.deletingFilesDetails(translogPath, translogFiles);
        return Tuple.tuple(RemoveCorruptedShardDataCommand.CleanStatus.CORRUPTED, details);
    }

    public void execute(Terminal terminal, ShardPath shardPath, Directory indexDirectory) throws IOException {
        List<IndexCommit> commits;
        Set<Path> translogFiles;
        Path indexPath = shardPath.resolveIndex();
        Path translogPath = shardPath.resolveTranslog();
        String historyUUID = UUIDs.randomBase64UUID();
        try {
            terminal.println("Checking existing translog files");
            translogFiles = TruncateTranslogAction.filesInDirectory(translogPath);
        }
        catch (IOException e) {
            terminal.println("encountered IOException while listing directory, aborting...");
            throw new ElasticsearchException("failed to find existing translog files", (Throwable)e, new Object[0]);
        }
        try {
            terminal.println("Reading translog UUID information from Lucene commit from shard at [" + indexPath + "]");
            commits = DirectoryReader.listCommits(indexDirectory);
        }
        catch (IndexNotFoundException infe) {
            throw new ElasticsearchException("unable to find a valid shard at [" + indexPath + "]", (Throwable)infe, new Object[0]);
        }
        Map<String, String> commitData = commits.get(commits.size() - 1).getUserData();
        String translogGeneration = commitData.get("translog_generation");
        String translogUUID = commitData.get("translog_uuid");
        if (translogGeneration == null || translogUUID == null) {
            throw new ElasticsearchException("shard must have a valid translog generation and UUID but got: [{}] and: [{}]", translogGeneration, translogUUID);
        }
        long globalCheckpoint = commitData.containsKey("max_seq_no") ? Long.parseLong(commitData.get("max_seq_no")) : -2L;
        terminal.println("Translog Generation: " + translogGeneration);
        terminal.println("Translog UUID      : " + translogUUID);
        terminal.println("History UUID       : " + historyUUID);
        Path tempEmptyCheckpoint = translogPath.resolve("temp-translog.ckp");
        Path realEmptyCheckpoint = translogPath.resolve("translog.ckp");
        Path tempEmptyTranslog = translogPath.resolve("temp-translog-" + translogGeneration + ".tlog");
        Path realEmptyTranslog = translogPath.resolve("translog-" + translogGeneration + ".tlog");
        long gen = Long.parseLong(translogGeneration);
        int translogLen = TruncateTranslogAction.writeEmptyTranslog(tempEmptyTranslog, translogUUID);
        TruncateTranslogAction.writeEmptyCheckpoint(tempEmptyCheckpoint, translogLen, gen, globalCheckpoint);
        terminal.println("Removing existing translog files");
        IOUtils.rm(translogFiles.toArray(new Path[0]));
        terminal.println("Creating new empty checkpoint at [" + realEmptyCheckpoint + "]");
        Files.move(tempEmptyCheckpoint, realEmptyCheckpoint, StandardCopyOption.ATOMIC_MOVE);
        terminal.println("Creating new empty translog at [" + realEmptyTranslog + "]");
        Files.move(tempEmptyTranslog, realEmptyTranslog, StandardCopyOption.ATOMIC_MOVE);
        IOUtils.fsync(translogPath, true);
    }

    private boolean isTranslogClean(ShardPath shardPath, String translogUUID) throws IOException {
        try {
            Path translogPath = shardPath.resolveTranslog();
            long translogGlobalCheckpoint = Translog.readGlobalCheckpoint(translogPath, translogUUID);
            IndexMetaData indexMetaData = IndexMetaData.FORMAT.loadLatestState(logger, this.namedXContentRegistry, shardPath.getDataPath().getParent());
            IndexSettings indexSettings = new IndexSettings(indexMetaData, Settings.EMPTY);
            TranslogConfig translogConfig = new TranslogConfig(shardPath.getShardId(), translogPath, indexSettings, BigArrays.NON_RECYCLING_INSTANCE);
            long primaryTerm = indexSettings.getIndexMetaData().primaryTerm(shardPath.getShardId().id());
            TranslogDeletionPolicy translogDeletionPolicy = new TranslogDeletionPolicy(indexSettings.getTranslogRetentionSize().getBytes(), indexSettings.getTranslogRetentionAge().getMillis(), Integer.MAX_VALUE);
            try (Translog translog = new Translog(translogConfig, translogUUID, translogDeletionPolicy, () -> translogGlobalCheckpoint, () -> primaryTerm);
                 Translog.Snapshot snapshot = translog.newSnapshot();){
                while (snapshot.next() != null) {
                }
            }
            return true;
        }
        catch (TranslogCorruptedException e) {
            return false;
        }
    }

    private static void writeEmptyCheckpoint(Path filename, int translogLength, long translogGeneration, long globalCheckpoint) throws IOException {
        Checkpoint emptyCheckpoint = Checkpoint.emptyTranslogCheckpoint(translogLength, translogGeneration, globalCheckpoint, translogGeneration);
        Checkpoint.write(FileChannel::open, filename, emptyCheckpoint, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE_NEW);
        IOUtils.fsync(filename, false);
    }

    private static int writeEmptyTranslog(Path filename, String translogUUID) throws IOException {
        try (FileChannel fc = FileChannel.open(filename, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);){
            TranslogHeader header = new TranslogHeader(translogUUID, 0L);
            header.write(fc);
            int n = header.sizeInBytes();
            return n;
        }
    }

    private String deletingFilesDetails(Path translogPath, Set<Path> files) {
        StringBuilder builder = new StringBuilder();
        builder.append("Documents inside of translog files will be lost.\n").append("  The following files will be DELETED at ").append(translogPath).append("\n\n");
        Iterator<Path> it = files.iterator();
        while (it.hasNext()) {
            builder.append("  --> ").append(it.next().getFileName());
            if (!it.hasNext()) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    private static Set<Path> filesInDirectory(Path directory) throws IOException {
        TreeSet<Path> files = new TreeSet<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
            for (Path file : stream) {
                files.add(file);
            }
        }
        return files;
    }
}

