/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.ingest;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.cluster.AbstractDiffable;
import conductor.org.elasticsearch.cluster.Diff;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ContextParser;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentHelper;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public final class PipelineConfiguration
extends AbstractDiffable<PipelineConfiguration>
implements ToXContentObject {
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("pipeline_config", true, () -> new Builder());
    private final String id;
    private final BytesReference config;
    private final XContentType xContentType;

    public static ContextParser<Void, PipelineConfiguration> getParser() {
        return (parser, context) -> PARSER.apply(parser, null).build();
    }

    public PipelineConfiguration(String id, BytesReference config, XContentType xContentType) {
        this.id = Objects.requireNonNull(id);
        this.config = Objects.requireNonNull(config);
        this.xContentType = Objects.requireNonNull(xContentType);
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getConfigAsMap() {
        return XContentHelper.convertToMap(this.config, true, this.xContentType).v2();
    }

    XContentType getXContentType() {
        return this.xContentType;
    }

    BytesReference getConfig() {
        return this.config;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", this.id);
        builder.field("config", this.getConfigAsMap());
        builder.endObject();
        return builder;
    }

    public static PipelineConfiguration readFrom(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(Version.V_5_3_0)) {
            return new PipelineConfiguration(in.readString(), in.readBytesReference(), in.readEnum(XContentType.class));
        }
        String id = in.readString();
        BytesReference config = in.readBytesReference();
        return new PipelineConfiguration(id, config, XContentHelper.xContentType(config));
    }

    public static Diff<PipelineConfiguration> readDiffFrom(StreamInput in) throws IOException {
        return PipelineConfiguration.readDiffFrom(PipelineConfiguration::readFrom, in);
    }

    public String toString() {
        return Strings.toString(this);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeBytesReference(this.config);
        if (out.getVersion().onOrAfter(Version.V_5_3_0)) {
            out.writeEnum(this.xContentType);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineConfiguration that = (PipelineConfiguration)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        return this.getConfigAsMap().equals(that.getConfigAsMap());
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.getConfigAsMap().hashCode();
        return result;
    }

    static {
        PARSER.declareString(Builder::setId, new ParseField("id", new String[0]));
        PARSER.declareField((parser, builder, aVoid) -> {
            XContentBuilder contentBuilder = XContentBuilder.builder(parser.contentType().xContent());
            contentBuilder.generator().copyCurrentStructure(parser);
            builder.setConfig(BytesReference.bytes(contentBuilder), contentBuilder.contentType());
        }, new ParseField("config", new String[0]), ObjectParser.ValueType.OBJECT);
    }

    private static class Builder {
        private String id;
        private BytesReference config;
        private XContentType xContentType;

        private Builder() {
        }

        void setId(String id) {
            this.id = id;
        }

        void setConfig(BytesReference config, XContentType xContentType) {
            this.config = config;
            this.xContentType = xContentType;
        }

        PipelineConfiguration build() {
            return new PipelineConfiguration(this.id, this.config, this.xContentType);
        }
    }
}

