/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.join.query;

import conductor.org.apache.lucene.search.BooleanClause;
import conductor.org.apache.lucene.search.BooleanQuery;
import conductor.org.apache.lucene.search.MatchNoDocsQuery;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.join.ScoreMode;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.ParsingException;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.lucene.search.Queries;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.index.fielddata.plain.SortedSetDVOrdinalsIndexFieldData;
import conductor.org.elasticsearch.index.mapper.DocumentMapper;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.index.mapper.ParentFieldMapper;
import conductor.org.elasticsearch.index.query.AbstractQueryBuilder;
import conductor.org.elasticsearch.index.query.InnerHitBuilder;
import conductor.org.elasticsearch.index.query.InnerHitContextBuilder;
import conductor.org.elasticsearch.index.query.QueryBuilder;
import conductor.org.elasticsearch.index.query.QueryRewriteContext;
import conductor.org.elasticsearch.index.query.QueryShardContext;
import conductor.org.elasticsearch.index.query.QueryShardException;
import conductor.org.elasticsearch.join.mapper.ParentIdFieldMapper;
import conductor.org.elasticsearch.join.mapper.ParentJoinFieldMapper;
import conductor.org.elasticsearch.join.query.HasChildQueryBuilder;
import conductor.org.elasticsearch.join.query.ParentChildInnerHitContextBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;

public class HasParentQueryBuilder
extends AbstractQueryBuilder<HasParentQueryBuilder> {
    public static final String NAME = "has_parent";
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    private static final ParseField PARENT_TYPE_FIELD = new ParseField("parent_type", new String[0]);
    private static final ParseField SCORE_FIELD = new ParseField("score", new String[0]);
    private static final ParseField INNER_HITS_FIELD = new ParseField("inner_hits", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final QueryBuilder query;
    private final String type;
    private final boolean score;
    private InnerHitBuilder innerHitBuilder;
    private boolean ignoreUnmapped = false;

    public HasParentQueryBuilder(String type, QueryBuilder query, boolean score) {
        this(type, query, score, null);
    }

    private HasParentQueryBuilder(String type, QueryBuilder query, boolean score, InnerHitBuilder innerHitBuilder) {
        this.type = HasParentQueryBuilder.requireValue(type, "[has_parent] requires '" + PARENT_TYPE_FIELD.getPreferredName() + "' field");
        this.query = HasParentQueryBuilder.requireValue(query, "[has_parent] requires '" + QUERY_FIELD.getPreferredName() + "' field");
        this.score = score;
        this.innerHitBuilder = innerHitBuilder;
    }

    public HasParentQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.type = in.readString();
        this.score = in.readBoolean();
        this.query = in.readNamedWriteable(QueryBuilder.class);
        this.innerHitBuilder = in.readOptionalWriteable(InnerHitBuilder::new);
        this.ignoreUnmapped = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.type);
        out.writeBoolean(this.score);
        out.writeNamedWriteable(this.query);
        if (out.getVersion().before(Version.V_5_5_0)) {
            boolean hasInnerHit = this.innerHitBuilder != null;
            out.writeBoolean(hasInnerHit);
            if (hasInnerHit) {
                this.innerHitBuilder.writeToParentChildBWC(out, this.query, this.type);
            }
        } else {
            out.writeOptionalWriteable(this.innerHitBuilder);
        }
        out.writeBoolean(this.ignoreUnmapped);
    }

    public QueryBuilder query() {
        return this.query;
    }

    public boolean score() {
        return this.score;
    }

    public String type() {
        return this.type;
    }

    public InnerHitBuilder innerHit() {
        return this.innerHitBuilder;
    }

    public HasParentQueryBuilder innerHit(InnerHitBuilder innerHit) {
        this.innerHitBuilder = innerHit;
        this.innerHitBuilder.setIgnoreUnmapped(this.ignoreUnmapped);
        return this;
    }

    public HasParentQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        if (this.innerHitBuilder != null) {
            this.innerHitBuilder.setIgnoreUnmapped(ignoreUnmapped);
        }
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        if (context.getIndexSettings().isSingleType()) {
            return this.joinFieldDoToQuery(context);
        }
        return this.parentFieldDoToQuery(context);
    }

    private Query joinFieldDoToQuery(QueryShardContext context) throws IOException {
        ParentJoinFieldMapper joinFieldMapper = ParentJoinFieldMapper.getMapper(context.getMapperService());
        if (joinFieldMapper == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException(context, "[has_parent] no join field has been configured", new Object[0]);
        }
        ParentIdFieldMapper parentIdFieldMapper = joinFieldMapper.getParentIdFieldMapper(this.type, true);
        if (parentIdFieldMapper != null) {
            Query parentFilter = parentIdFieldMapper.getParentFilter();
            BooleanQuery innerQuery = Queries.filtered(this.query.toQuery(context), parentFilter);
            Query childFilter = parentIdFieldMapper.getChildrenFilter();
            MappedFieldType fieldType = parentIdFieldMapper.fieldType();
            SortedSetDVOrdinalsIndexFieldData fieldData = (SortedSetDVOrdinalsIndexFieldData)context.getForField(fieldType);
            return new HasChildQueryBuilder.LateParsingQuery(childFilter, innerQuery, 0, Integer.MAX_VALUE, fieldType.name(), this.score ? ScoreMode.Max : ScoreMode.None, fieldData, context.getSearchSimilarity());
        }
        if (this.ignoreUnmapped) {
            return new MatchNoDocsQuery();
        }
        throw new QueryShardException(context, "[has_parent] join field [" + joinFieldMapper.name() + "] doesn't hold [" + this.type + "] as a parent", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Query parentFieldDoToQuery(QueryShardContext context) throws IOException {
        Query childrenQuery;
        Query innerQuery;
        String[] previousTypes = context.getTypes();
        context.setTypes(this.type);
        try {
            innerQuery = this.query.toQuery(context);
        }
        finally {
            context.setTypes(previousTypes);
        }
        DocumentMapper parentDocMapper = context.documentMapper(this.type);
        if (parentDocMapper == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException(context, "[has_parent] query configured 'parent_type' [" + this.type + "] is not a valid type", new Object[0]);
        }
        HashSet<String> childTypes = new HashSet<String>();
        for (DocumentMapper documentMapper : context.getMapperService().docMappers(false)) {
            ParentFieldMapper parentFieldMapper = documentMapper.parentFieldMapper();
            if (!parentFieldMapper.active() || !this.type.equals(parentFieldMapper.type())) continue;
            childTypes.add(documentMapper.type());
        }
        if (childTypes.isEmpty()) {
            throw new QueryShardException(context, "[has_parent] no child types found for type [" + this.type + "]", new Object[0]);
        }
        if (childTypes.size() == 1) {
            DocumentMapper documentMapper;
            documentMapper = context.getMapperService().documentMapper((String)childTypes.iterator().next());
            childrenQuery = documentMapper.typeFilter(context);
        } else {
            BooleanQuery.Builder childrenFilter = new BooleanQuery.Builder();
            for (String childrenTypeStr : childTypes) {
                DocumentMapper documentMapper = context.getMapperService().documentMapper(childrenTypeStr);
                childrenFilter.add(documentMapper.typeFilter(context), BooleanClause.Occur.SHOULD);
            }
            childrenQuery = childrenFilter.build();
        }
        innerQuery = Queries.filtered(innerQuery, parentDocMapper.typeFilter(context));
        MappedFieldType parentType = parentDocMapper.parentFieldMapper().getParentJoinFieldType();
        SortedSetDVOrdinalsIndexFieldData fieldData = (SortedSetDVOrdinalsIndexFieldData)context.getForField(parentType);
        return new HasChildQueryBuilder.LateParsingQuery(childrenQuery, innerQuery, 0, Integer.MAX_VALUE, ParentFieldMapper.joinField(this.type), this.score ? ScoreMode.Max : ScoreMode.None, fieldData, context.getSearchSimilarity());
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName());
        this.query.toXContent(builder, params);
        builder.field(PARENT_TYPE_FIELD.getPreferredName(), this.type);
        builder.field(SCORE_FIELD.getPreferredName(), this.score);
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.printBoostAndQueryName(builder);
        if (this.innerHitBuilder != null) {
            builder.field(INNER_HITS_FIELD.getPreferredName(), this.innerHitBuilder, params);
        }
        builder.endObject();
    }

    public static HasParentQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        float boost = 1.0f;
        String parentType = null;
        boolean score = false;
        String queryName = null;
        InnerHitBuilder innerHits = null;
        boolean ignoreUnmapped = false;
        String currentFieldName = null;
        QueryBuilder iqb = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (QUERY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    iqb = HasParentQueryBuilder.parseInnerQueryBuilder(parser);
                    continue;
                }
                if (INNER_HITS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    innerHits = InnerHitBuilder.fromXContent(parser);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[has_parent] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (!token.isValue()) continue;
            if (PARENT_TYPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                parentType = parser.text();
                continue;
            }
            if (SCORE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                score = parser.booleanValue();
                continue;
            }
            if (IGNORE_UNMAPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                ignoreUnmapped = parser.booleanValue();
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[has_parent] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        HasParentQueryBuilder queryBuilder = (HasParentQueryBuilder)((HasParentQueryBuilder)new HasParentQueryBuilder(parentType, iqb, score).ignoreUnmapped(ignoreUnmapped).queryName(queryName)).boost(boost);
        if (innerHits != null) {
            queryBuilder.innerHit(innerHits);
        }
        return queryBuilder;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected boolean doEquals(HasParentQueryBuilder that) {
        return Objects.equals(this.query, that.query) && Objects.equals(this.type, that.type) && Objects.equals(this.score, that.score) && Objects.equals(this.innerHitBuilder, that.innerHitBuilder) && Objects.equals(this.ignoreUnmapped, that.ignoreUnmapped);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.query, this.type, this.score, this.innerHitBuilder, this.ignoreUnmapped);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        QueryBuilder rewrittenQuery = this.query.rewrite(queryShardContext);
        if (rewrittenQuery != this.query) {
            HasParentQueryBuilder hasParentQueryBuilder = new HasParentQueryBuilder(this.type, rewrittenQuery, this.score, this.innerHitBuilder);
            hasParentQueryBuilder.ignoreUnmapped(this.ignoreUnmapped);
            return hasParentQueryBuilder;
        }
        return this;
    }

    @Override
    protected void extractInnerHitBuilders(Map<String, InnerHitContextBuilder> innerHits) {
        if (this.innerHitBuilder != null) {
            String name;
            String string = name = this.innerHitBuilder.getName() != null ? this.innerHitBuilder.getName() : this.type;
            if (innerHits.containsKey(name)) {
                throw new IllegalArgumentException("[inner_hits] already contains an entry for key [" + name + "]");
            }
            HashMap<String, InnerHitContextBuilder> children = new HashMap<String, InnerHitContextBuilder>();
            InnerHitContextBuilder.extractInnerHits(this.query, children);
            ParentChildInnerHitContextBuilder innerHitContextBuilder = new ParentChildInnerHitContextBuilder(this.type, false, this.query, this.innerHitBuilder, children);
            innerHits.put(name, innerHitContextBuilder);
        }
    }
}

