/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.monitor.fs;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.elasticsearch.cluster.ClusterInfo;
import conductor.org.elasticsearch.cluster.ClusterInfoService;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.settings.Setting;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.common.util.SingleObjectCache;
import conductor.org.elasticsearch.env.NodeEnvironment;
import conductor.org.elasticsearch.monitor.fs.FsInfo;
import conductor.org.elasticsearch.monitor.fs.FsProbe;
import java.io.IOException;

public class FsService {
    private static final Logger logger = LogManager.getLogger(FsService.class);
    private final FsProbe probe;
    private final TimeValue refreshInterval;
    private final SingleObjectCache<FsInfo> cache;
    private final ClusterInfoService clusterInfoService;
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting("monitor.fs.refresh_interval", TimeValue.timeValueSeconds(1L), TimeValue.timeValueSeconds(1L), Setting.Property.NodeScope);

    public FsService(Settings settings, NodeEnvironment nodeEnvironment, ClusterInfoService clusterInfoService) {
        this.probe = new FsProbe(nodeEnvironment);
        this.clusterInfoService = clusterInfoService;
        this.refreshInterval = REFRESH_INTERVAL_SETTING.get(settings);
        logger.debug("using refresh_interval [{}]", (Object)this.refreshInterval);
        this.cache = new FsInfoCache(this.refreshInterval, FsService.stats(this.probe, null, logger, null));
    }

    public FsInfo stats() {
        return this.cache.getOrRefresh();
    }

    private static FsInfo stats(FsProbe probe, FsInfo initialValue, Logger logger, @Nullable ClusterInfo clusterInfo) {
        try {
            return probe.stats(initialValue, clusterInfo);
        }
        catch (IOException e) {
            logger.debug("unexpected exception reading filesystem info", (Throwable)e);
            return null;
        }
    }

    private class FsInfoCache
    extends SingleObjectCache<FsInfo> {
        private final FsInfo initialValue;

        FsInfoCache(TimeValue interval, FsInfo initialValue) {
            super(interval, initialValue);
            this.initialValue = initialValue;
        }

        @Override
        protected FsInfo refresh() {
            return FsService.stats(FsService.this.probe, this.initialValue, logger, FsService.this.clusterInfoService.getClusterInfo());
        }
    }
}

