/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.monitor.jvm;

import conductor.org.apache.lucene.util.CollectionUtil;
import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.common.time.DateFormatter;
import conductor.org.elasticsearch.common.time.DateFormatters;
import conductor.org.elasticsearch.common.unit.TimeValue;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.function.ToLongFunction;

public class HotThreads {
    private static final Object mutex = new Object();
    private static final DateFormatter DATE_TIME_FORMATTER = DateFormatters.forPattern("dateOptionalTime");
    private int busiestThreads = 3;
    private TimeValue interval = new TimeValue(500L, TimeUnit.MILLISECONDS);
    private TimeValue threadElementsSnapshotDelay = new TimeValue(10L);
    private int threadElementsSnapshotCount = 10;
    private String type = "cpu";
    private boolean ignoreIdleThreads = true;
    private static final StackTraceElement[] EMPTY = new StackTraceElement[0];

    public HotThreads interval(TimeValue interval) {
        this.interval = interval;
        return this;
    }

    public HotThreads busiestThreads(int busiestThreads) {
        this.busiestThreads = busiestThreads;
        return this;
    }

    public HotThreads ignoreIdleThreads(boolean ignoreIdleThreads) {
        this.ignoreIdleThreads = ignoreIdleThreads;
        return this;
    }

    public HotThreads threadElementsSnapshotDelay(TimeValue threadElementsSnapshotDelay) {
        this.threadElementsSnapshotDelay = threadElementsSnapshotDelay;
        return this;
    }

    public HotThreads threadElementsSnapshotCount(int threadElementsSnapshotCount) {
        this.threadElementsSnapshotCount = threadElementsSnapshotCount;
        return this;
    }

    public HotThreads type(String type) {
        if (!("cpu".equals(type) || "wait".equals(type) || "block".equals(type))) {
            throw new IllegalArgumentException("type not supported [" + type + "]");
        }
        this.type = type;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String detect() throws Exception {
        Object object = mutex;
        synchronized (object) {
            return this.innerDetect();
        }
    }

    private static boolean isIdleThread(ThreadInfo threadInfo) {
        String threadName = threadInfo.getThreadName();
        if (threadName.equals("Signal Dispatcher") || threadName.equals("Finalizer") || threadName.equals("Reference Handler")) {
            return true;
        }
        for (StackTraceElement frame : threadInfo.getStackTrace()) {
            String className = frame.getClassName();
            String methodName = frame.getMethodName();
            if (className.equals("java.util.concurrent.ThreadPoolExecutor") && methodName.equals("getTask")) {
                return true;
            }
            if (className.equals("sun.nio.ch.SelectorImpl") && methodName.equals("select")) {
                return true;
            }
            if (className.equals("conductor.org.elasticsearch.threadpool.ThreadPool$CachedTimeThread") && methodName.equals("run")) {
                return true;
            }
            if (className.equals("conductor.org.elasticsearch.indices.ttl.IndicesTTLService$Notifier") && methodName.equals("await")) {
                return true;
            }
            if (!className.equals("java.util.concurrent.LinkedTransferQueue") || !methodName.equals("poll")) continue;
            return true;
        }
        return false;
    }

    private String innerDetect() throws Exception {
        ToLongFunction<MyThreadInfo> getter;
        ThreadInfo info;
        long cpu;
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        if (!threadBean.isThreadCpuTimeSupported()) {
            throw new ElasticsearchException("thread CPU time is not supported on this JDK", new Object[0]);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Hot threads at ");
        sb.append(DATE_TIME_FORMATTER.format(LocalDateTime.now(Clock.systemUTC())));
        sb.append(", interval=");
        sb.append(this.interval);
        sb.append(", busiestThreads=");
        sb.append(this.busiestThreads);
        sb.append(", ignoreIdleThreads=");
        sb.append(this.ignoreIdleThreads);
        sb.append(":\n");
        HashMap<Long, MyThreadInfo> threadInfos = new HashMap<Long, MyThreadInfo>();
        for (long threadId : threadBean.getAllThreadIds()) {
            if (Thread.currentThread().getId() == threadId || (cpu = threadBean.getThreadCpuTime(threadId)) == -1L || (info = threadBean.getThreadInfo(threadId, 0)) == null) continue;
            threadInfos.put(threadId, new MyThreadInfo(cpu, info));
        }
        Thread.sleep(this.interval.millis());
        for (long threadId : threadBean.getAllThreadIds()) {
            if (Thread.currentThread().getId() == threadId) continue;
            cpu = threadBean.getThreadCpuTime(threadId);
            if (cpu == -1L) {
                threadInfos.remove(threadId);
                continue;
            }
            info = threadBean.getThreadInfo(threadId, 0);
            if (info == null) {
                threadInfos.remove(threadId);
                continue;
            }
            MyThreadInfo data = (MyThreadInfo)threadInfos.get(threadId);
            if (data != null) {
                data.setDelta(cpu, info);
                continue;
            }
            threadInfos.remove(threadId);
        }
        ArrayList hotties = new ArrayList(threadInfos.values());
        int busiestThreads = Math.min(this.busiestThreads, hotties.size());
        if ("cpu".equals(this.type)) {
            getter = o -> o.cpuTime;
        } else if ("wait".equals(this.type)) {
            getter = o -> o.waitedTime;
        } else if ("block".equals(this.type)) {
            getter = o -> o.blockedTime;
        } else {
            throw new IllegalArgumentException("expected thread type to be either 'cpu', 'wait', or 'block', but was " + this.type);
        }
        CollectionUtil.introSort(hotties, Comparator.comparingLong(getter).reversed());
        long[] ids = new long[busiestThreads];
        for (int i = 0; i < busiestThreads; ++i) {
            MyThreadInfo info2 = (MyThreadInfo)hotties.get(i);
            ids[i] = info2.info.getThreadId();
        }
        ThreadInfo[][] allInfos = new ThreadInfo[this.threadElementsSnapshotCount][];
        for (int j = 0; j < this.threadElementsSnapshotCount; ++j) {
            allInfos[j] = threadBean.getThreadInfo(ids, Integer.MAX_VALUE);
            Thread.sleep(this.threadElementsSnapshotDelay.millis());
        }
        for (int t = 0; t < busiestThreads; ++t) {
            long time = getter.applyAsLong((MyThreadInfo)hotties.get(t));
            String threadName = null;
            for (ThreadInfo[] info3 : allInfos) {
                if (info3 == null || info3[t] == null) continue;
                if (this.ignoreIdleThreads && HotThreads.isIdleThread(info3[t])) {
                    info3[t] = null;
                    continue;
                }
                threadName = info3[t].getThreadName();
                break;
            }
            if (threadName == null) continue;
            double percent = (double)time / (double)this.interval.nanos() * 100.0;
            sb.append(String.format(Locale.ROOT, "%n%4.1f%% (%s out of %s) %s usage by thread '%s'%n", percent, TimeValue.timeValueNanos(time), this.interval, this.type, threadName));
            boolean[] done = new boolean[this.threadElementsSnapshotCount];
            for (int i = 0; i < this.threadElementsSnapshotCount; ++i) {
                int l;
                if (done[i]) continue;
                int maxSim = 1;
                boolean[] similars = new boolean[this.threadElementsSnapshotCount];
                for (int j = i + 1; j < this.threadElementsSnapshotCount; ++j) {
                    if (done[j]) continue;
                    int similarity = this.similarity(allInfos[i][t], allInfos[j][t]);
                    if (similarity > maxSim) {
                        maxSim = similarity;
                        similars = new boolean[this.threadElementsSnapshotCount];
                    }
                    if (similarity != maxSim) continue;
                    similars[j] = true;
                }
                int count = 1;
                for (int j = i + 1; j < this.threadElementsSnapshotCount; ++j) {
                    if (!similars[j]) continue;
                    done[j] = true;
                    ++count;
                }
                if (allInfos[i][t] == null) continue;
                StackTraceElement[] show = allInfos[i][t].getStackTrace();
                if (count == 1) {
                    sb.append(String.format(Locale.ROOT, "  unique snapshot%n", new Object[0]));
                    for (l = 0; l < show.length; ++l) {
                        sb.append(String.format(Locale.ROOT, "    %s%n", show[l]));
                    }
                    continue;
                }
                sb.append(String.format(Locale.ROOT, "  %d/%d snapshots sharing following %d elements%n", count, this.threadElementsSnapshotCount, maxSim));
                for (l = show.length - maxSim; l < show.length; ++l) {
                    sb.append(String.format(Locale.ROOT, "    %s%n", show[l]));
                }
            }
        }
        return sb.toString();
    }

    private int similarity(ThreadInfo threadInfo, ThreadInfo threadInfo0) {
        StackTraceElement[] s1 = threadInfo == null ? EMPTY : threadInfo.getStackTrace();
        StackTraceElement[] s2 = threadInfo0 == null ? EMPTY : threadInfo0.getStackTrace();
        int i = s1.length - 1;
        int rslt = 0;
        for (int j = s2.length - 1; i >= 0 && j >= 0 && s1[i].equals(s2[j]); --i, --j) {
            ++rslt;
        }
        return rslt;
    }

    class MyThreadInfo {
        long cpuTime;
        long blockedCount;
        long blockedTime;
        long waitedCount;
        long waitedTime;
        boolean deltaDone;
        ThreadInfo info;

        MyThreadInfo(long cpuTime, ThreadInfo info) {
            this.blockedCount = info.getBlockedCount();
            this.blockedTime = info.getBlockedTime();
            this.waitedCount = info.getWaitedCount();
            this.waitedTime = info.getWaitedTime();
            this.cpuTime = cpuTime;
            this.info = info;
        }

        void setDelta(long cpuTime, ThreadInfo info) {
            if (this.deltaDone) {
                throw new IllegalStateException("setDelta already called once");
            }
            this.blockedCount = info.getBlockedCount() - this.blockedCount;
            this.blockedTime = info.getBlockedTime() - this.blockedTime;
            this.waitedCount = info.getWaitedCount() - this.waitedCount;
            this.waitedTime = info.getWaitedTime() - this.waitedTime;
            this.cpuTime = cpuTime - this.cpuTime;
            this.deltaDone = true;
            this.info = info;
        }
    }
}

