/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action;

import conductor.org.elasticsearch.action.main.MainAction;
import conductor.org.elasticsearch.action.main.MainRequest;
import conductor.org.elasticsearch.action.main.MainResponse;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.BytesRestResponse;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.RestResponse;
import conductor.org.elasticsearch.rest.RestStatus;
import conductor.org.elasticsearch.rest.action.RestBuilderListener;
import java.io.IOException;

public class RestMainAction
extends BaseRestHandler {
    public RestMainAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/", this);
    }

    @Override
    public String getName() {
        return "main_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        return channel -> client.execute(MainAction.INSTANCE, new MainRequest(), new RestBuilderListener<MainResponse>(channel){

            @Override
            public RestResponse buildResponse(MainResponse mainResponse, XContentBuilder builder) throws Exception {
                return RestMainAction.convertMainResponse(mainResponse, request, builder);
            }
        });
    }

    static BytesRestResponse convertMainResponse(MainResponse response, RestRequest request, XContentBuilder builder) throws IOException {
        RestStatus status;
        RestStatus restStatus = status = response.isAvailable() ? RestStatus.OK : RestStatus.SERVICE_UNAVAILABLE;
        if (!request.hasParam("pretty")) {
            builder.prettyPrint().lfAtEnd();
        }
        response.toXContent(builder, request);
        return new BytesRestResponse(status, builder);
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }
}

