/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.admin.cluster;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import conductor.org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import conductor.org.elasticsearch.action.admin.cluster.state.TransportClusterStateAction;
import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.client.Requests;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.settings.SettingsFilter;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.BytesRestResponse;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.RestResponse;
import conductor.org.elasticsearch.rest.RestStatus;
import conductor.org.elasticsearch.rest.action.RestBuilderListener;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class RestClusterStateAction
extends BaseRestHandler {
    private final SettingsFilter settingsFilter;
    private static final Set<String> RESPONSE_PARAMS;

    public RestClusterStateAction(Settings settings, RestController controller, SettingsFilter settingsFilter) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_cluster/state", this);
        controller.registerHandler(RestRequest.Method.GET, "/_cluster/state/{metric}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_cluster/state/{metric}/{indices}", this);
        this.settingsFilter = settingsFilter;
    }

    @Override
    public String getName() {
        return "cluster_state_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        boolean isAllIndicesOnly;
        final ClusterStateRequest clusterStateRequest = Requests.clusterStateRequest();
        clusterStateRequest.indicesOptions(IndicesOptions.fromRequest(request, clusterStateRequest.indicesOptions()));
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.masterNodeTimeout(request.paramAsTime("master_timeout", clusterStateRequest.masterNodeTimeout()));
        if (request.hasParam("wait_for_metadata_version")) {
            clusterStateRequest.waitForMetaDataVersion(request.paramAsLong("wait_for_metadata_version", 0L));
        }
        clusterStateRequest.waitForTimeout(request.paramAsTime("wait_for_timeout", ClusterStateRequest.DEFAULT_WAIT_FOR_NODE_TIMEOUT));
        String[] indices = Strings.splitStringByCommaToArray(request.param("indices", "_all"));
        boolean bl = isAllIndicesOnly = indices.length == 1 && "_all".equals(indices[0]);
        if (!isAllIndicesOnly) {
            clusterStateRequest.indices(indices);
        }
        if (request.hasParam("metric")) {
            EnumSet<ClusterState.Metric> metrics = ClusterState.Metric.parseString(request.param("metric"), true);
            clusterStateRequest.nodes(metrics.contains((Object)ClusterState.Metric.NODES) || metrics.contains((Object)ClusterState.Metric.MASTER_NODE));
            clusterStateRequest.routingTable(metrics.contains((Object)ClusterState.Metric.ROUTING_TABLE) || metrics.contains((Object)ClusterState.Metric.ROUTING_NODES));
            clusterStateRequest.metaData(metrics.contains((Object)ClusterState.Metric.METADATA));
            clusterStateRequest.blocks(metrics.contains((Object)ClusterState.Metric.BLOCKS));
            clusterStateRequest.customs(metrics.contains((Object)ClusterState.Metric.CUSTOMS));
        }
        this.settingsFilter.addFilterSettingParams(request);
        return channel -> client.admin().cluster().state(clusterStateRequest, (ActionListener<ClusterStateResponse>)new RestBuilderListener<ClusterStateResponse>(channel){

            @Override
            public RestResponse buildResponse(ClusterStateResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                if (clusterStateRequest.waitForMetaDataVersion() != null) {
                    builder.field("wait_for_timed_out", response.isWaitForTimedOut());
                }
                builder.field("cluster_name", response.getClusterName().value());
                if (TransportClusterStateAction.CLUSTER_STATE_SIZE) {
                    builder.humanReadableField("compressed_size_in_bytes", "compressed_size", response.getTotalCompressedSize());
                }
                response.getState().toXContent(builder, request);
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    static {
        HashSet<String> responseParams = new HashSet<String>();
        responseParams.add("metric");
        responseParams.addAll(Settings.FORMAT_PARAMS);
        RESPONSE_PARAMS = Collections.unmodifiableSet(responseParams);
    }

    static final class Fields {
        static final String WAIT_FOR_TIMED_OUT = "wait_for_timed_out";
        static final String CLUSTER_NAME = "cluster_name";
        static final String CLUSTER_STATE_SIZE = "compressed_size";
        static final String CLUSTER_STATE_SIZE_IN_BYTES = "compressed_size_in_bytes";

        Fields() {
        }
    }
}

