/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.admin.indices;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequest;
import conductor.org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.logging.DeprecationLogger;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.util.set.Sets;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.RestStatus;
import conductor.org.elasticsearch.rest.action.RestToXContentListener;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

public class RestGetIndexTemplateAction
extends BaseRestHandler {
    private static final Set<String> RESPONSE_PARAMETERS = Collections.unmodifiableSet(Sets.union(Collections.singleton("include_type_name"), Settings.FORMAT_PARAMS));
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestGetIndexTemplateAction.class));
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] The parameter include_type_name should be explicitly specified in get template requests to prepare for 7.0. In 7.0 include_type_name will default to 'false', which means responses will omit the type name in mapping definitions.";

    public RestGetIndexTemplateAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_template", this);
        controller.registerHandler(RestRequest.Method.GET, "/_template/{name}", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/_template/{name}", this);
    }

    @Override
    public String getName() {
        return "get_index_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] names = Strings.splitStringByCommaToArray(request.param("name"));
        GetIndexTemplatesRequest getIndexTemplatesRequest = new GetIndexTemplatesRequest(names);
        if (!request.hasParam("include_type_name")) {
            deprecationLogger.deprecatedAndMaybeLog("get_index_template_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        }
        getIndexTemplatesRequest.local(request.paramAsBoolean("local", getIndexTemplatesRequest.local()));
        getIndexTemplatesRequest.masterNodeTimeout(request.paramAsTime("master_timeout", getIndexTemplatesRequest.masterNodeTimeout()));
        final boolean implicitAll = getIndexTemplatesRequest.names().length == 0;
        return channel -> client.admin().indices().getTemplates(getIndexTemplatesRequest, (ActionListener<GetIndexTemplatesResponse>)new RestToXContentListener<GetIndexTemplatesResponse>(channel){

            @Override
            protected RestStatus getStatus(GetIndexTemplatesResponse response) {
                boolean templateExists = !response.getIndexTemplates().isEmpty();
                return templateExists || implicitAll ? RestStatus.OK : RestStatus.NOT_FOUND;
            }
        });
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMETERS;
    }
}

