/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.cat;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import conductor.org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import conductor.org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import conductor.org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import conductor.org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.cluster.node.DiscoveryNodes;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.Table;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.RestResponse;
import conductor.org.elasticsearch.rest.action.RestActionListener;
import conductor.org.elasticsearch.rest.action.RestResponseListener;
import conductor.org.elasticsearch.rest.action.cat.AbstractCatAction;
import conductor.org.elasticsearch.rest.action.cat.RestTable;
import java.util.Map;

public class RestNodeAttrsAction
extends AbstractCatAction {
    public RestNodeAttrsAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_cat/nodeattrs", this);
    }

    @Override
    public String getName() {
        return "cat_node_attrs_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/nodeattrs\n");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, final NodeClient client) {
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.clear().nodes(true);
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.masterNodeTimeout(request.paramAsTime("master_timeout", clusterStateRequest.masterNodeTimeout()));
        return channel -> client.admin().cluster().state(clusterStateRequest, (ActionListener<ClusterStateResponse>)new RestActionListener<ClusterStateResponse>(channel){

            @Override
            public void processResponse(final ClusterStateResponse clusterStateResponse) {
                NodesInfoRequest nodesInfoRequest = new NodesInfoRequest();
                nodesInfoRequest.clear().jvm(false).os(false).process(true);
                client.admin().cluster().nodesInfo(nodesInfoRequest, (ActionListener<NodesInfoResponse>)new RestResponseListener<NodesInfoResponse>(this.channel){

                    @Override
                    public RestResponse buildResponse(NodesInfoResponse nodesInfoResponse) throws Exception {
                        return RestTable.buildResponse(RestNodeAttrsAction.this.buildTable(request, clusterStateResponse, nodesInfoResponse), this.channel);
                    }
                });
            }
        });
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell("node", "default:true;alias:name;desc:node name");
        table.addCell("id", "default:false;alias:id,nodeId;desc:unique node id");
        table.addCell("pid", "default:false;alias:p;desc:process id");
        table.addCell("host", "alias:h;desc:host name");
        table.addCell("ip", "alias:i;desc:ip address");
        table.addCell("port", "default:false;alias:po;desc:bound transport port");
        table.addCell("attr", "default:true;alias:attr.name;desc:attribute description");
        table.addCell("value", "default:true;alias:attr.value;desc:attribute value");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest req, ClusterStateResponse state, NodesInfoResponse nodesInfo) {
        boolean fullId = req.paramAsBoolean("full_id", false);
        DiscoveryNodes nodes = state.getState().nodes();
        Table table = this.getTableWithHeader(req);
        for (DiscoveryNode node : nodes) {
            NodeInfo info = (NodeInfo)nodesInfo.getNodesMap().get(node.getId());
            for (Map.Entry<String, String> attrEntry : node.getAttributes().entrySet()) {
                table.startRow();
                table.addCell(node.getName());
                table.addCell(fullId ? node.getId() : Strings.substring(node.getId(), 0, 4));
                table.addCell(info == null ? null : Long.valueOf(info.getProcess().getId()));
                table.addCell(node.getHostName());
                table.addCell(node.getHostAddress());
                table.addCell(node.getAddress().address().getPort());
                table.addCell(attrEntry.getKey());
                table.addCell(attrEntry.getValue());
                table.endRow();
            }
        }
        return table;
    }
}

