/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.search;

import conductor.org.elasticsearch.action.search.ClearScrollRequest;
import conductor.org.elasticsearch.action.search.ClearScrollResponse;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.RestChannel;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.action.RestStatusToXContentListener;
import java.io.IOException;
import java.util.Arrays;

public class RestClearScrollAction
extends BaseRestHandler {
    public RestClearScrollAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.DELETE, "/_search/scroll", this);
        controller.registerHandler(RestRequest.Method.DELETE, "/_search/scroll/{scroll_id}", this);
    }

    @Override
    public String getName() {
        return "clear_scroll_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String scrollIds = request.param("scroll_id");
        ClearScrollRequest clearRequest = new ClearScrollRequest();
        clearRequest.setScrollIds(Arrays.asList(Strings.splitStringByCommaToArray(scrollIds)));
        request.withContentOrSourceParamParserOrNull(xContentParser -> {
            if (xContentParser != null) {
                try {
                    clearRequest.fromXContent((XContentParser)xContentParser);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to parse request body", e);
                }
            }
        });
        return channel -> client.clearScroll(clearRequest, new RestStatusToXContentListener<ClearScrollResponse>((RestChannel)channel));
    }
}

