/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.search.aggregations.Aggregation;
import conductor.org.elasticsearch.search.aggregations.Aggregations;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.InternalAggregations;
import conductor.org.elasticsearch.search.aggregations.InvalidAggregationPathException;
import conductor.org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import conductor.org.elasticsearch.search.aggregations.bucket.SingleBucketAggregation;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public abstract class InternalMultiBucketAggregation<A extends InternalMultiBucketAggregation, B extends InternalBucket>
extends InternalAggregation
implements MultiBucketsAggregation {
    public InternalMultiBucketAggregation(String name, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
    }

    protected InternalMultiBucketAggregation(StreamInput in) throws IOException {
        super(in);
    }

    public abstract A create(List<B> var1);

    public abstract B createBucket(InternalAggregations var1, B var2);

    public abstract List<? extends InternalBucket> getBuckets();

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.get(0).equals("_bucket_count")) {
            return this.getBuckets().size();
        }
        List<InternalBucket> buckets = this.getBuckets();
        Object[] propertyArray = new Object[buckets.size()];
        for (int i = 0; i < buckets.size(); ++i) {
            propertyArray[i] = buckets.get(i).getProperty(this.getName(), path);
        }
        return propertyArray;
    }

    public static int countInnerBucket(InternalBucket bucket) {
        int count = 0;
        for (Aggregation agg : bucket.getAggregations().asList()) {
            count += InternalMultiBucketAggregation.countInnerBucket(agg);
        }
        return count;
    }

    public static int countInnerBucket(Aggregation agg) {
        int size;
        block4: {
            block3: {
                size = 0;
                if (!(agg instanceof MultiBucketsAggregation)) break block3;
                MultiBucketsAggregation multi = (MultiBucketsAggregation)agg;
                for (MultiBucketsAggregation.Bucket bucket : multi.getBuckets()) {
                    ++size;
                    for (Aggregation bucketAgg : bucket.getAggregations().asList()) {
                        size += InternalMultiBucketAggregation.countInnerBucket(bucketAgg);
                    }
                }
                break block4;
            }
            if (!(agg instanceof SingleBucketAggregation)) break block4;
            SingleBucketAggregation single = (SingleBucketAggregation)agg;
            for (Aggregation aggregation : single.getAggregations().asList()) {
                size += InternalMultiBucketAggregation.countInnerBucket(aggregation);
            }
        }
        return size;
    }

    public static abstract class InternalBucket
    implements MultiBucketsAggregation.Bucket,
    Writeable {
        public Object getProperty(String containingAggName, List<String> path) {
            if (path.isEmpty()) {
                return this;
            }
            Aggregations aggregations = this.getAggregations();
            String aggName = path.get(0);
            if (aggName.equals("_count")) {
                if (path.size() > 1) {
                    throw new InvalidAggregationPathException("_count must be the last element in the path");
                }
                return this.getDocCount();
            }
            if (aggName.equals("_key")) {
                if (path.size() > 1) {
                    throw new InvalidAggregationPathException("_key must be the last element in the path");
                }
                return this.getKey();
            }
            InternalAggregation aggregation = (InternalAggregation)aggregations.get(aggName);
            if (aggregation == null) {
                throw new InvalidAggregationPathException("Cannot find an aggregation named [" + aggName + "] in [" + containingAggName + "]");
            }
            return aggregation.getProperty(path.subList(1, path.size()));
        }
    }
}

