/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.composite;

import conductor.org.apache.lucene.index.IndexOptions;
import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.search.Query;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.lease.Releasable;
import conductor.org.elasticsearch.common.util.BigArrays;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.search.DocValueFormat;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollector;
import conductor.org.elasticsearch.search.aggregations.bucket.composite.SortedDocsProducer;
import java.io.IOException;

abstract class SingleDimensionValuesSource<T extends Comparable<T>>
implements Releasable {
    protected final BigArrays bigArrays;
    protected final DocValueFormat format;
    @Nullable
    protected final MappedFieldType fieldType;
    @Nullable
    protected final Object missing;
    protected final boolean missingBucket;
    protected final int size;
    protected final int reverseMul;
    protected T afterValue;

    SingleDimensionValuesSource(BigArrays bigArrays, DocValueFormat format, @Nullable MappedFieldType fieldType, boolean missingBucket, @Nullable Object missing, int size, int reverseMul) {
        assert (missing == null || !missingBucket);
        this.bigArrays = bigArrays;
        this.format = format;
        this.fieldType = fieldType;
        this.missing = missing;
        this.missingBucket = missingBucket;
        this.size = size;
        this.reverseMul = reverseMul;
        this.afterValue = null;
    }

    abstract void copyCurrent(int var1);

    abstract int compare(int var1, int var2);

    abstract int compareCurrent(int var1);

    abstract int compareCurrentWithAfter();

    abstract int hashCode(int var1);

    abstract int hashCodeCurrent();

    abstract void setAfter(Comparable var1);

    T getAfter() {
        return this.afterValue;
    }

    abstract T toComparable(int var1) throws IOException;

    abstract LeafBucketCollector getLeafCollector(LeafReaderContext var1, LeafBucketCollector var2) throws IOException;

    abstract LeafBucketCollector getLeafCollector(Comparable var1, LeafReaderContext var2, LeafBucketCollector var3) throws IOException;

    abstract SortedDocsProducer createSortedDocsProducerOrNull(IndexReader var1, Query var2);

    protected boolean checkIfSortedDocsIsApplicable(IndexReader reader, MappedFieldType fieldType) {
        if (fieldType == null || this.missing != null || this.missingBucket && this.afterValue == null || fieldType.indexOptions() == IndexOptions.NONE || this.reverseMul == -1) {
            return false;
        }
        return !reader.hasDeletions() || reader.numDocs() != 0 && !((double)reader.numDocs() / (double)reader.maxDoc() < 0.5);
    }
}

