/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.range;

import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactories;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.bucket.range.InternalRange;
import conductor.org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSource;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class AbstractRangeAggregatorFactory<AF extends AbstractRangeAggregatorFactory<AF, R>, R extends RangeAggregator.Range>
extends ValuesSourceAggregatorFactory<ValuesSource.Numeric, AF> {
    private final InternalRange.Factory<?, ?> rangeFactory;
    private final R[] ranges;
    private final boolean keyed;

    public AbstractRangeAggregatorFactory(String name, ValuesSourceConfig<ValuesSource.Numeric> config, R[] ranges, boolean keyed, InternalRange.Factory<?, ?> rangeFactory, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metaData);
        this.ranges = ranges;
        this.keyed = keyed;
        this.rangeFactory = rangeFactory;
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        return new RangeAggregator.Unmapped(this.name, this.ranges, this.keyed, this.config.format(), this.context, parent, this.rangeFactory, pipelineAggregators, metaData);
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource.Numeric valuesSource, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        return new RangeAggregator(this.name, this.factories, valuesSource, this.config.format(), this.rangeFactory, (RangeAggregator.Range[])this.ranges, this.keyed, this.context, parent, pipelineAggregators, metaData);
    }
}

