/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.metrics.sum;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.elasticsearch.common.lease.Releasables;
import conductor.org.elasticsearch.common.util.BigArrays;
import conductor.org.elasticsearch.common.util.DoubleArray;
import conductor.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import conductor.org.elasticsearch.search.DocValueFormat;
import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollector;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import conductor.org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import conductor.org.elasticsearch.search.aggregations.metrics.sum.InternalSum;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSource;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class SumAggregator
extends NumericMetricsAggregator.SingleValue {
    private final ValuesSource.Numeric valuesSource;
    private final DocValueFormat format;
    private DoubleArray sums;
    private DoubleArray compensations;

    SumAggregator(String name, ValuesSource.Numeric valuesSource, DocValueFormat formatter, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.format = formatter;
        if (valuesSource != null) {
            this.sums = context.bigArrays().newDoubleArray(1L, true);
            this.compensations = context.bigArrays().newDoubleArray(1L, true);
        }
    }

    @Override
    public boolean needsScores() {
        return this.valuesSource != null && this.valuesSource.needsScores();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                SumAggregator.this.sums = bigArrays.grow(SumAggregator.this.sums, bucket + 1L);
                SumAggregator.this.compensations = bigArrays.grow(SumAggregator.this.compensations, bucket + 1L);
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    double sum = SumAggregator.this.sums.get(bucket);
                    double compensation = SumAggregator.this.compensations.get(bucket);
                    for (int i = 0; i < valuesCount; ++i) {
                        double value = values.nextValue();
                        if (!Double.isFinite(value)) {
                            sum += value;
                            continue;
                        }
                        if (!Double.isFinite(sum)) continue;
                        double corrected = value - compensation;
                        double newSum = sum + corrected;
                        compensation = newSum - sum - corrected;
                        sum = newSum;
                    }
                    SumAggregator.this.compensations.set(bucket, compensation);
                    SumAggregator.this.sums.set(bucket, sum);
                }
            }
        };
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.sums.size()) {
            return 0.0;
        }
        return this.sums.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalSum(this.name, this.sums.get(bucket), this.format, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalSum(this.name, 0.0, this.format, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public void doClose() {
        Releasables.close(this.sums, this.compensations);
    }
}

