/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.pipeline.cumulativesum;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.search.DocValueFormat;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.InternalAggregations;
import conductor.org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import conductor.org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import conductor.org.elasticsearch.search.aggregations.bucket.histogram.HistogramFactory;
import conductor.org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import conductor.org.elasticsearch.search.aggregations.pipeline.InternalSimpleValue;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class CumulativeSumPipelineAggregator
extends PipelineAggregator {
    private final DocValueFormat formatter;

    public CumulativeSumPipelineAggregator(String name, String[] bucketsPaths, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, bucketsPaths, metadata);
        this.formatter = formatter;
    }

    public CumulativeSumPipelineAggregator(StreamInput in) throws IOException {
        super(in);
        this.formatter = in.readNamedWriteable(DocValueFormat.class);
    }

    @Override
    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.formatter);
    }

    @Override
    public String getWriteableName() {
        return "cumulative_sum";
    }

    @Override
    public InternalAggregation reduce(InternalAggregation aggregation, InternalAggregation.ReduceContext reduceContext) {
        InternalMultiBucketAggregation histo = (InternalMultiBucketAggregation)aggregation;
        List<InternalMultiBucketAggregation.InternalBucket> buckets = histo.getBuckets();
        HistogramFactory factory = (HistogramFactory)((Object)histo);
        ArrayList<MultiBucketsAggregation.Bucket> newBuckets = new ArrayList<MultiBucketsAggregation.Bucket>(buckets.size());
        double sum = 0.0;
        for (InternalMultiBucketAggregation.InternalBucket bucket : buckets) {
            Double thisBucketValue = BucketHelpers.resolveBucketValue((MultiBucketsAggregation)histo, bucket, this.bucketsPaths()[0], BucketHelpers.GapPolicy.INSERT_ZEROS);
            if (thisBucketValue != null && !thisBucketValue.isInfinite() && !thisBucketValue.isNaN()) {
                sum += thisBucketValue.doubleValue();
            }
            List<InternalAggregation> aggs = StreamSupport.stream(bucket.getAggregations().spliterator(), false).map(p -> (InternalAggregation)p).collect(Collectors.toList());
            aggs.add(new InternalSimpleValue(this.name(), sum, this.formatter, new ArrayList<PipelineAggregator>(), this.metaData()));
            MultiBucketsAggregation.Bucket newBucket = factory.createBucket(factory.getKey(bucket), bucket.getDocCount(), new InternalAggregations(aggs));
            newBuckets.add(newBucket);
        }
        return factory.createAggregation(newBuckets);
    }
}

