/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.fetch.subphase;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.NumericDocValues;
import conductor.org.apache.lucene.index.ReaderUtil;
import conductor.org.elasticsearch.search.SearchHit;
import conductor.org.elasticsearch.search.fetch.FetchSubPhase;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

public final class VersionFetchSubPhase
implements FetchSubPhase {
    @Override
    public void hitsExecute(SearchContext context, SearchHit[] hits) throws IOException {
        if (!context.version() || context.storedFieldsContext() != null && !context.storedFieldsContext().fetchFields()) {
            return;
        }
        hits = (SearchHit[])hits.clone();
        Arrays.sort(hits, Comparator.comparingInt(SearchHit::docId));
        int lastReaderId = -1;
        NumericDocValues versions = null;
        for (SearchHit hit : hits) {
            int readerId = ReaderUtil.subIndex(hit.docId(), context.searcher().getIndexReader().leaves());
            LeafReaderContext subReaderContext = context.searcher().getIndexReader().leaves().get(readerId);
            if (lastReaderId != readerId) {
                versions = subReaderContext.reader().getNumericDocValues("_version");
                lastReaderId = readerId;
            }
            int docId = hit.docId() - subReaderContext.docBase;
            long version = -1L;
            if (versions != null && versions.advanceExact(docId)) {
                version = versions.longValue();
            }
            hit.version(version < 0L ? -1L : version);
        }
    }
}

