/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.sort;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.lucene.search.SortField;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.logging.DeprecationLogger;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.index.fielddata.IndexFieldData;
import conductor.org.elasticsearch.index.fielddata.IndexNumericFieldData;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.index.query.QueryBuilder;
import conductor.org.elasticsearch.index.query.QueryRewriteContext;
import conductor.org.elasticsearch.index.query.QueryShardContext;
import conductor.org.elasticsearch.index.query.QueryShardException;
import conductor.org.elasticsearch.search.DocValueFormat;
import conductor.org.elasticsearch.search.MultiValueMode;
import conductor.org.elasticsearch.search.sort.NestedSortBuilder;
import conductor.org.elasticsearch.search.sort.SortBuilder;
import conductor.org.elasticsearch.search.sort.SortFieldAndFormat;
import conductor.org.elasticsearch.search.sort.SortMode;
import conductor.org.elasticsearch.search.sort.SortOrder;
import java.io.IOException;
import java.util.Objects;

public class FieldSortBuilder
extends SortBuilder<FieldSortBuilder> {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(FieldSortBuilder.class));
    public static final String NAME = "field_sort";
    public static final ParseField MISSING = new ParseField("missing", new String[0]);
    public static final ParseField SORT_MODE = new ParseField("mode", new String[0]);
    public static final ParseField UNMAPPED_TYPE = new ParseField("unmapped_type", new String[0]);
    public static final String DOC_FIELD_NAME = "_doc";
    private static final SortFieldAndFormat SORT_DOC = new SortFieldAndFormat(new SortField(null, SortField.Type.DOC), DocValueFormat.RAW);
    private static final SortFieldAndFormat SORT_DOC_REVERSE = new SortFieldAndFormat(new SortField(null, SortField.Type.DOC, true), DocValueFormat.RAW);
    private final String fieldName;
    private Object missing;
    private String unmappedType;
    private SortMode sortMode;
    private QueryBuilder nestedFilter;
    private String nestedPath;
    private NestedSortBuilder nestedSort;
    private static ObjectParser<FieldSortBuilder, Void> PARSER = new ObjectParser("field_sort");

    public FieldSortBuilder(FieldSortBuilder template) {
        this(template.fieldName);
        this.order(template.order());
        this.missing(template.missing());
        this.unmappedType(template.unmappedType());
        if (template.sortMode != null) {
            this.sortMode(template.sortMode());
        }
        this.setNestedFilter(template.getNestedFilter());
        this.setNestedPath(template.getNestedPath());
        if (template.getNestedSort() != null) {
            this.setNestedSort(template.getNestedSort());
        }
    }

    public FieldSortBuilder(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        this.fieldName = fieldName;
    }

    public FieldSortBuilder(StreamInput in) throws IOException {
        this.fieldName = in.readString();
        this.nestedFilter = in.readOptionalNamedWriteable(QueryBuilder.class);
        this.nestedPath = in.readOptionalString();
        this.missing = in.readGenericValue();
        this.order = in.readOptionalWriteable(SortOrder::readFromStream);
        this.sortMode = in.readOptionalWriteable(SortMode::readFromStream);
        this.unmappedType = in.readOptionalString();
        if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
            this.nestedSort = in.readOptionalWriteable(NestedSortBuilder::new);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeOptionalNamedWriteable(this.nestedFilter);
        out.writeOptionalString(this.nestedPath);
        out.writeGenericValue(this.missing);
        out.writeOptionalWriteable(this.order);
        out.writeOptionalWriteable(this.sortMode);
        out.writeOptionalString(this.unmappedType);
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeOptionalWriteable(this.nestedSort);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public FieldSortBuilder missing(Object missing) {
        this.missing = missing;
        return this;
    }

    public Object missing() {
        return this.missing;
    }

    public FieldSortBuilder unmappedType(String type) {
        this.unmappedType = type;
        return this;
    }

    public String unmappedType() {
        return this.unmappedType;
    }

    public FieldSortBuilder sortMode(SortMode sortMode) {
        Objects.requireNonNull(sortMode, "sort mode cannot be null");
        this.sortMode = sortMode;
        return this;
    }

    public SortMode sortMode() {
        return this.sortMode;
    }

    @Deprecated
    public FieldSortBuilder setNestedFilter(QueryBuilder nestedFilter) {
        if (this.nestedSort != null) {
            throw new IllegalArgumentException("Setting both nested_path/nested_filter and nested not allowed");
        }
        this.nestedFilter = nestedFilter;
        return this;
    }

    @Deprecated
    public QueryBuilder getNestedFilter() {
        return this.nestedFilter;
    }

    @Deprecated
    public FieldSortBuilder setNestedPath(String nestedPath) {
        if (this.nestedSort != null) {
            throw new IllegalArgumentException("Setting both nested_path/nested_filter and nested not allowed");
        }
        this.nestedPath = nestedPath;
        return this;
    }

    @Deprecated
    public String getNestedPath() {
        return this.nestedPath;
    }

    public NestedSortBuilder getNestedSort() {
        return this.nestedSort;
    }

    public FieldSortBuilder setNestedSort(NestedSortBuilder nestedSort) {
        if (this.nestedFilter != null || this.nestedPath != null) {
            throw new IllegalArgumentException("Setting both nested_path/nested_filter and nested not allowed");
        }
        this.nestedSort = nestedSort;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(this.fieldName);
        builder.field(ORDER_FIELD.getPreferredName(), this.order);
        if (this.missing != null) {
            builder.field(MISSING.getPreferredName(), this.missing);
        }
        if (this.unmappedType != null) {
            builder.field(UNMAPPED_TYPE.getPreferredName(), this.unmappedType);
        }
        if (this.sortMode != null) {
            builder.field(SORT_MODE.getPreferredName(), this.sortMode);
        }
        if (this.nestedFilter != null) {
            builder.field(NESTED_FILTER_FIELD.getPreferredName(), this.nestedFilter, params);
        }
        if (this.nestedPath != null) {
            builder.field(NESTED_PATH_FIELD.getPreferredName(), this.nestedPath);
        }
        if (this.nestedSort != null) {
            builder.field(NestedSortBuilder.NESTED_FIELD.getPreferredName(), this.nestedSort);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    public SortFieldAndFormat build(QueryShardContext context) throws IOException {
        Object fieldData;
        boolean reverse;
        if (DOC_FIELD_NAME.equals(this.fieldName)) {
            if (this.order == SortOrder.DESC) {
                return SORT_DOC_REVERSE;
            }
            return SORT_DOC;
        }
        boolean isUnmapped = false;
        MappedFieldType fieldType = context.fieldMapper(this.fieldName);
        if (fieldType == null) {
            isUnmapped = true;
            if (this.unmappedType != null) {
                fieldType = context.getMapperService().unmappedFieldType(this.unmappedType);
            } else {
                throw new QueryShardException(context, "No mapping found for [" + this.fieldName + "] in order to sort on", new Object[0]);
            }
        }
        MultiValueMode localSortMode = null;
        if (this.sortMode != null) {
            localSortMode = MultiValueMode.fromString(this.sortMode.toString());
        }
        boolean bl = reverse = this.order == SortOrder.DESC;
        if (localSortMode == null) {
            localSortMode = reverse ? MultiValueMode.MAX : MultiValueMode.MIN;
        }
        IndexFieldData.XFieldComparatorSource.Nested nested = null;
        if (!isUnmapped) {
            if (this.nestedSort != null) {
                if (context.indexVersionCreated().before(Version.V_6_5_0) && this.nestedSort.getMaxChildren() != Integer.MAX_VALUE) {
                    throw new QueryShardException(context, "max_children is only supported on v6.5.0 or higher", new Object[0]);
                }
                if (this.nestedSort.getNestedSort() != null && this.nestedSort.getMaxChildren() != Integer.MAX_VALUE) {
                    throw new QueryShardException(context, "max_children is only supported on last level of nested sort", new Object[0]);
                }
                nested = FieldSortBuilder.resolveNested(context, this.nestedSort);
            } else {
                nested = FieldSortBuilder.resolveNested(context, this.nestedPath, this.nestedFilter);
            }
        }
        if (!((fieldData = context.getForField(fieldType)) instanceof IndexNumericFieldData || this.sortMode != SortMode.SUM && this.sortMode != SortMode.AVG && this.sortMode != SortMode.MEDIAN)) {
            throw new QueryShardException(context, "we only support AVG, MEDIAN and SUM on number based fields", new Object[0]);
        }
        SortField field = fieldData.sortField(this.missing, localSortMode, nested, reverse);
        return new SortFieldAndFormat(field, fieldType.docValueFormat(null, null));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FieldSortBuilder builder = (FieldSortBuilder)other;
        return Objects.equals(this.fieldName, builder.fieldName) && Objects.equals(this.nestedFilter, builder.nestedFilter) && Objects.equals(this.nestedPath, builder.nestedPath) && Objects.equals(this.missing, builder.missing) && Objects.equals(this.order, builder.order) && Objects.equals(this.sortMode, builder.sortMode) && Objects.equals(this.unmappedType, builder.unmappedType) && Objects.equals(this.nestedSort, builder.nestedSort);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.nestedFilter, this.nestedPath, this.nestedSort, this.missing, this.order, this.sortMode, this.unmappedType);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public static FieldSortBuilder fromXContent(XContentParser parser, String fieldName) throws IOException {
        return PARSER.parse(parser, new FieldSortBuilder(fieldName), null);
    }

    @Override
    public FieldSortBuilder rewrite(QueryRewriteContext ctx) throws IOException {
        if (this.nestedFilter == null && this.nestedSort == null) {
            return this;
        }
        if (this.nestedFilter != null) {
            QueryBuilder rewrite = this.nestedFilter.rewrite(ctx);
            if (this.nestedFilter == rewrite) {
                return this;
            }
            return new FieldSortBuilder(this).setNestedFilter(rewrite);
        }
        NestedSortBuilder rewrite = this.nestedSort.rewrite(ctx);
        if (this.nestedSort == rewrite) {
            return this;
        }
        return new FieldSortBuilder(this).setNestedSort(rewrite);
    }

    static {
        PARSER.declareField(FieldSortBuilder::missing, p -> p.objectText(), MISSING, ObjectParser.ValueType.VALUE);
        PARSER.declareString((fieldSortBuilder, nestedPath) -> {
            DEPRECATION_LOGGER.deprecated("[nested_path] has been deprecated in favor of the [nested] parameter", new Object[0]);
            fieldSortBuilder.setNestedPath((String)nestedPath);
        }, NESTED_PATH_FIELD);
        PARSER.declareString(FieldSortBuilder::unmappedType, UNMAPPED_TYPE);
        PARSER.declareString((b, v) -> b.order(SortOrder.fromString(v)), ORDER_FIELD);
        PARSER.declareString((b, v) -> b.sortMode(SortMode.fromString(v)), SORT_MODE);
        PARSER.declareObject(FieldSortBuilder::setNestedFilter, (p, c) -> {
            DEPRECATION_LOGGER.deprecated("[nested_filter] has been deprecated in favour for the [nested] parameter", new Object[0]);
            return SortBuilder.parseNestedFilter(p);
        }, NESTED_FILTER_FIELD);
        PARSER.declareObject(FieldSortBuilder::setNestedSort, (p, c) -> NestedSortBuilder.fromXContent(p), NestedSortBuilder.NESTED_FIELD);
    }
}

