/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.suggest.completion;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.search.BulkScorer;
import conductor.org.apache.lucene.search.CollectionTerminatedException;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.apache.lucene.search.suggest.document.CompletionQuery;
import conductor.org.apache.lucene.search.suggest.document.TopSuggestDocs;
import conductor.org.apache.lucene.search.suggest.document.TopSuggestDocsCollector;
import conductor.org.apache.lucene.util.CharsRefBuilder;
import conductor.org.elasticsearch.common.text.Text;
import conductor.org.elasticsearch.index.mapper.CompletionFieldMapper;
import conductor.org.elasticsearch.search.suggest.Suggest;
import conductor.org.elasticsearch.search.suggest.Suggester;
import conductor.org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import conductor.org.elasticsearch.search.suggest.completion.CompletionSuggestionContext;
import conductor.org.elasticsearch.search.suggest.completion.TopSuggestGroupDocsCollector;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompletionSuggester
extends Suggester<CompletionSuggestionContext> {
    public static final CompletionSuggester INSTANCE = new CompletionSuggester();

    private CompletionSuggester() {
    }

    @Override
    protected Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> innerExecute(String name, CompletionSuggestionContext suggestionContext, IndexSearcher searcher, CharsRefBuilder spare) throws IOException {
        if (suggestionContext.getFieldType() != null) {
            CompletionFieldMapper.CompletionFieldType fieldType = suggestionContext.getFieldType();
            CompletionSuggestion completionSuggestion = new CompletionSuggestion(name, suggestionContext.getSize(), suggestionContext.isSkipDuplicates());
            spare.copyUTF8Bytes(suggestionContext.getText());
            CompletionSuggestion.Entry completionSuggestEntry = new CompletionSuggestion.Entry(new Text(spare.toString()), 0, spare.length());
            completionSuggestion.addTerm(completionSuggestEntry);
            int shardSize = suggestionContext.getShardSize() != null ? suggestionContext.getShardSize().intValue() : suggestionContext.getSize();
            TopSuggestGroupDocsCollector collector = new TopSuggestGroupDocsCollector(shardSize, suggestionContext.isSkipDuplicates());
            CompletionSuggester.suggest(searcher, suggestionContext.toQuery(), collector);
            int numResult = 0;
            for (TopSuggestDocs.SuggestScoreDoc suggestDoc : collector.get().scoreLookupDocs()) {
                List<CharSequence> rawContexts;
                Map<String, Set<String>> contexts = Collections.emptyMap();
                if (fieldType.hasContextMappings() && (rawContexts = collector.getContexts(suggestDoc.doc)).size() > 0) {
                    contexts = fieldType.getContextMappings().getNamedContexts(rawContexts);
                }
                if (numResult++ >= suggestionContext.getSize()) break;
                CompletionSuggestion.Entry.Option option = new CompletionSuggestion.Entry.Option(suggestDoc.doc, new Text(suggestDoc.key.toString()), suggestDoc.score, contexts);
                completionSuggestEntry.addOption(option);
            }
            return completionSuggestion;
        }
        return null;
    }

    private static void suggest(IndexSearcher searcher, CompletionQuery query, TopSuggestDocsCollector collector) throws IOException {
        query = (CompletionQuery)query.rewrite(searcher.getIndexReader());
        Weight weight = query.createWeight(searcher, collector.needsScores(), 1.0f);
        for (LeafReaderContext context : searcher.getIndexReader().leaves()) {
            BulkScorer scorer = weight.bulkScorer(context);
            if (scorer == null) continue;
            try {
                scorer.score(collector.getLeafCollector(context), context.reader().getLiveDocs());
            }
            catch (CollectionTerminatedException collectionTerminatedException) {}
        }
    }
}

