/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.transport;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.compress.Compressor;
import conductor.org.elasticsearch.common.compress.CompressorFactory;
import conductor.org.elasticsearch.common.compress.NotCompressedException;
import conductor.org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import conductor.org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.util.concurrent.ThreadContext;
import conductor.org.elasticsearch.core.internal.io.IOUtils;
import conductor.org.elasticsearch.transport.NetworkMessage;
import conductor.org.elasticsearch.transport.TransportStatus;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public abstract class InboundMessage
extends NetworkMessage
implements Closeable {
    private final StreamInput streamInput;

    InboundMessage(ThreadContext threadContext, Version version, byte status, long requestId, StreamInput streamInput) {
        super(threadContext, version, status, requestId);
        this.streamInput = streamInput;
    }

    StreamInput getStreamInput() {
        return this.streamInput;
    }

    @Override
    public void close() throws IOException {
        this.streamInput.close();
    }

    private static void ensureVersionCompatibility(Version version, Version currentVersion, boolean isHandshake) {
        Version compatibilityVersion;
        Version version2 = compatibilityVersion = isHandshake ? currentVersion.minimumCompatibilityVersion() : currentVersion;
        if (!version.isCompatible(compatibilityVersion)) {
            Version minCompatibilityVersion = isHandshake ? compatibilityVersion : compatibilityVersion.minimumCompatibilityVersion();
            String msg = "Received " + (isHandshake ? "handshake " : "") + "message from unsupported version: [";
            throw new IllegalStateException(msg + version + "] minimal compatible version is: [" + minCompatibilityVersion + "]");
        }
    }

    public static class ResponseMessage
    extends InboundMessage {
        ResponseMessage(ThreadContext threadContext, Version version, byte status, long requestId, StreamInput streamInput) {
            super(threadContext, version, status, requestId, streamInput);
        }
    }

    public static class RequestMessage
    extends InboundMessage {
        private final String actionName;
        private final Set<String> features;

        RequestMessage(ThreadContext threadContext, Version version, byte status, long requestId, String actionName, Set<String> features, StreamInput streamInput) {
            super(threadContext, version, status, requestId, streamInput);
            this.actionName = actionName;
            this.features = features;
        }

        String getActionName() {
            return this.actionName;
        }

        Set<String> getFeatures() {
            return this.features;
        }
    }

    static class Reader {
        private final Version version;
        private final NamedWriteableRegistry namedWriteableRegistry;
        private final ThreadContext threadContext;

        Reader(Version version, NamedWriteableRegistry namedWriteableRegistry, ThreadContext threadContext) {
            this.version = version;
            this.namedWriteableRegistry = namedWriteableRegistry;
            this.threadContext = threadContext;
        }

        /*
         * Loose catch block
         */
        InboundMessage deserialize(BytesReference reference) throws IOException {
            ResponseMessage responseMessage;
            ThreadContext.StoredContext existing;
            boolean success;
            StreamInput streamInput;
            block16: {
                InboundMessage message;
                int messageLengthBytes = reference.length();
                int totalMessageSize = messageLengthBytes + 2 + 4;
                boolean hasMessageBytesToRead = totalMessageSize - 19 > 0;
                streamInput = reference.streamInput();
                success = false;
                existing = this.threadContext.stashContext();
                long requestId = streamInput.readLong();
                byte status = streamInput.readByte();
                Version remoteVersion = Version.fromId(streamInput.readInt());
                boolean isHandshake = TransportStatus.isHandshake(status);
                InboundMessage.ensureVersionCompatibility(remoteVersion, this.version, isHandshake);
                if (TransportStatus.isCompress(status) && hasMessageBytesToRead && streamInput.available() > 0) {
                    Compressor compressor;
                    try {
                        int bytesConsumed = 13;
                        compressor = CompressorFactory.compressor(reference.slice(13, reference.length() - 13));
                    }
                    catch (NotCompressedException ex) {
                        int maxToRead = Math.min(reference.length(), 10);
                        StringBuilder sb = new StringBuilder("stream marked as compressed, but no compressor found, first [").append(maxToRead).append("] content bytes out of [").append(reference.length()).append("] readable bytes with message size [").append(messageLengthBytes).append("] ").append("] are [");
                        for (int i = 0; i < maxToRead; ++i) {
                            sb.append(reference.get(i)).append(",");
                        }
                        sb.append("]");
                        throw new IllegalStateException(sb.toString());
                    }
                    streamInput = compressor.streamInput(streamInput);
                }
                streamInput = new NamedWriteableAwareStreamInput(streamInput, this.namedWriteableRegistry);
                streamInput.setVersion(remoteVersion);
                this.threadContext.readHeaders(streamInput);
                if (TransportStatus.isRequest(status)) {
                    Set<String> features = remoteVersion.onOrAfter(Version.V_6_3_0) ? Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList(streamInput.readStringArray()))) : Collections.emptySet();
                    String action = streamInput.readString();
                    message = new RequestMessage(this.threadContext, remoteVersion, status, requestId, action, features, streamInput);
                } else {
                    message = new ResponseMessage(this.threadContext, remoteVersion, status, requestId, streamInput);
                }
                success = true;
                responseMessage = message;
                if (existing != null) {
                    existing.close();
                }
                if (success) break block16;
                IOUtils.closeWhileHandlingException(streamInput);
            }
            return responseMessage;
            {
                catch (Throwable throwable) {
                    try {
                        if (existing != null) {
                            try {
                                existing.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        if (!success) {
                            IOUtils.closeWhileHandlingException(streamInput);
                        }
                        throw throwable3;
                    }
                }
            }
        }
    }
}

