/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.transport.netty4;

import conductor.io.netty.channel.Channel;
import conductor.io.netty.channel.ChannelFuture;
import conductor.io.netty.channel.ChannelPromise;
import conductor.io.netty.util.concurrent.Future;
import conductor.io.netty.util.concurrent.GenericFutureListener;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.concurrent.CompletableContext;
import conductor.org.elasticsearch.transport.TcpChannel;
import conductor.org.elasticsearch.transport.TransportException;
import conductor.org.elasticsearch.transport.netty4.Netty4Utils;
import java.net.InetSocketAddress;

public class Netty4TcpChannel
implements TcpChannel {
    private final Channel channel;
    private final boolean isServer;
    private final String profile;
    private final CompletableContext<Void> connectContext;
    private final CompletableContext<Void> closeContext = new CompletableContext();
    private final TcpChannel.ChannelStats stats = new TcpChannel.ChannelStats();

    Netty4TcpChannel(Channel channel, boolean isServer, String profile, @Nullable ChannelFuture connectFuture) {
        this.channel = channel;
        this.isServer = isServer;
        this.profile = profile;
        this.connectContext = new CompletableContext();
        this.channel.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            if (f.isSuccess()) {
                this.closeContext.complete(null);
            } else {
                Throwable cause = f.cause();
                if (cause instanceof Error) {
                    ExceptionsHelper.maybeDieOnAnotherThread(cause);
                    this.closeContext.completeExceptionally(new Exception(cause));
                } else {
                    this.closeContext.completeExceptionally((Exception)cause);
                }
            }
        }));
        connectFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            if (f.isSuccess()) {
                this.connectContext.complete(null);
            } else {
                Throwable cause = f.cause();
                if (cause instanceof Error) {
                    ExceptionsHelper.maybeDieOnAnotherThread(cause);
                    this.connectContext.completeExceptionally(new Exception(cause));
                } else {
                    this.connectContext.completeExceptionally((Exception)cause);
                }
            }
        }));
    }

    @Override
    public void close() {
        this.channel.close();
    }

    @Override
    public boolean isServerChannel() {
        return this.isServer;
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.addListener(ActionListener.toBiConsumer(listener));
    }

    @Override
    public void addConnectListener(ActionListener<Void> listener) {
        this.connectContext.addListener(ActionListener.toBiConsumer(listener));
    }

    @Override
    public TcpChannel.ChannelStats getChannelStats() {
        return this.stats;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    @Override
    public void sendMessage(BytesReference reference, ActionListener<Void> listener) {
        ChannelPromise writePromise = this.channel.newPromise();
        writePromise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            if (f.isSuccess()) {
                listener.onResponse(null);
            } else {
                Throwable cause = f.cause();
                ExceptionsHelper.maybeDieOnAnotherThread(cause);
                if (cause instanceof Error) {
                    listener.onFailure(new Exception(cause));
                } else {
                    listener.onFailure((Exception)cause);
                }
            }
        }));
        this.channel.writeAndFlush(Netty4Utils.toByteBuf(reference), writePromise);
        if (this.channel.eventLoop().isShutdown()) {
            listener.onFailure(new TransportException("Cannot send message, event loop is shutting down."));
        }
    }

    public Channel getLowLevelChannel() {
        return this.channel;
    }

    public String toString() {
        return "Netty4TcpChannel{localAddress=" + this.getLocalAddress() + ", remoteAddress=" + this.channel.remoteAddress() + '}';
    }
}

