/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis.miscellaneous;

import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.miscellaneous.DateRecognizerFilter;
import conductor.org.apache.lucene.analysis.util.TokenFilterFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;

public class DateRecognizerFilterFactory
extends TokenFilterFactory {
    public static final String DATE_PATTERN = "datePattern";
    public static final String LOCALE = "locale";
    private final DateFormat dateFormat;
    private final Locale locale;

    public DateRecognizerFilterFactory(Map<String, String> args) {
        super(args);
        this.locale = this.getLocale(this.get(args, LOCALE));
        this.dateFormat = this.getDataFormat(this.get(args, DATE_PATTERN));
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new DateRecognizerFilter(input, this.dateFormat);
    }

    private Locale getLocale(String localeStr) {
        if (localeStr == null) {
            return Locale.ENGLISH;
        }
        return new Locale.Builder().setLanguageTag(localeStr).build();
    }

    public DateFormat getDataFormat(String datePattern) {
        if (datePattern != null) {
            return new SimpleDateFormat(datePattern, this.locale);
        }
        return DateFormat.getDateInstance(2, this.locale);
    }
}

