/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis.pattern;

import conductor.org.apache.lucene.analysis.pattern.SimplePatternTokenizer;
import conductor.org.apache.lucene.analysis.util.TokenizerFactory;
import conductor.org.apache.lucene.util.AttributeFactory;
import conductor.org.apache.lucene.util.automaton.Automaton;
import conductor.org.apache.lucene.util.automaton.Operations;
import conductor.org.apache.lucene.util.automaton.RegExp;
import java.util.Map;

public class SimplePatternTokenizerFactory
extends TokenizerFactory {
    public static final String PATTERN = "pattern";
    private final Automaton dfa;
    private final int maxDeterminizedStates;

    public SimplePatternTokenizerFactory(Map<String, String> args) {
        super(args);
        this.maxDeterminizedStates = this.getInt(args, "maxDeterminizedStates", 10000);
        this.dfa = Operations.determinize(new RegExp(this.require(args, PATTERN)).toAutomaton(), this.maxDeterminizedStates);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public SimplePatternTokenizer create(AttributeFactory factory) {
        return new SimplePatternTokenizer(factory, this.dfa);
    }
}

