/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.reroute;

import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.ActionListenerResponseHandler;
import conductor.org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteRequest;
import conductor.org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteResponse;
import conductor.org.elasticsearch.action.admin.indices.shards.IndicesShardStoresRequest;
import conductor.org.elasticsearch.action.admin.indices.shards.IndicesShardStoresResponse;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import conductor.org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.block.ClusterBlockException;
import conductor.org.elasticsearch.cluster.block.ClusterBlockLevel;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.cluster.routing.allocation.AllocationService;
import conductor.org.elasticsearch.cluster.routing.allocation.RoutingExplanations;
import conductor.org.elasticsearch.cluster.routing.allocation.command.AbstractAllocateAllocationCommand;
import conductor.org.elasticsearch.cluster.routing.allocation.command.AllocateStalePrimaryAllocationCommand;
import conductor.org.elasticsearch.cluster.routing.allocation.command.AllocationCommand;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.Priority;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.collect.ImmutableOpenIntMap;
import conductor.org.elasticsearch.common.collect.ImmutableOpenMap;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransportClusterRerouteAction
extends TransportMasterNodeAction<ClusterRerouteRequest, ClusterRerouteResponse> {
    private final AllocationService allocationService;

    @Inject
    public TransportClusterRerouteAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, AllocationService allocationService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/reroute", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, ClusterRerouteRequest::new);
        this.allocationService = allocationService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterRerouteRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected ClusterRerouteResponse newResponse() {
        return new ClusterRerouteResponse();
    }

    @Override
    protected void masterOperation(ClusterRerouteRequest request, ClusterState state, ActionListener<ClusterRerouteResponse> listener) {
        HashMap<String, List<AbstractAllocateAllocationCommand>> stalePrimaryAllocations = new HashMap<String, List<AbstractAllocateAllocationCommand>>();
        for (AllocationCommand command : request.getCommands().commands()) {
            if (!(command instanceof AllocateStalePrimaryAllocationCommand)) continue;
            AllocateStalePrimaryAllocationCommand cmd = (AllocateStalePrimaryAllocationCommand)command;
            stalePrimaryAllocations.computeIfAbsent(cmd.index(), k -> new ArrayList()).add(cmd);
        }
        if (stalePrimaryAllocations.isEmpty()) {
            this.submitStateUpdate(request, listener);
        } else {
            this.verifyThenSubmitUpdate(request, listener, stalePrimaryAllocations);
        }
    }

    private void verifyThenSubmitUpdate(ClusterRerouteRequest request, ActionListener<ClusterRerouteResponse> listener, Map<String, List<AbstractAllocateAllocationCommand>> stalePrimaryAllocations) {
        this.transportService.sendRequest(this.transportService.getLocalNode(), "indices:monitor/shard_stores", new IndicesShardStoresRequest().indices(stalePrimaryAllocations.keySet().toArray(Strings.EMPTY_ARRAY)), new ActionListenerResponseHandler<IndicesShardStoresResponse>(ActionListener.wrap(response -> {
            ImmutableOpenMap<String, ImmutableOpenIntMap<List<IndicesShardStoresResponse.StoreStatus>>> status = response.getStoreStatuses();
            Exception e = null;
            for (Map.Entry entry : stalePrimaryAllocations.entrySet()) {
                String index = (String)entry.getKey();
                ImmutableOpenIntMap<List<IndicesShardStoresResponse.StoreStatus>> indexStatus = status.get(index);
                if (indexStatus == null) continue;
                for (AbstractAllocateAllocationCommand command : (List)entry.getValue()) {
                    List<IndicesShardStoresResponse.StoreStatus> shardStatus = indexStatus.get(command.shardId());
                    if (shardStatus == null || shardStatus.isEmpty()) {
                        e = ExceptionsHelper.useOrSuppress(e, new IllegalArgumentException("No data for shard [" + command.shardId() + "] of index [" + index + "] found on any node"));
                        continue;
                    }
                    if (!shardStatus.stream().noneMatch(storeStatus -> {
                        DiscoveryNode node = storeStatus.getNode();
                        String nodeInCommand = command.node();
                        return nodeInCommand.equals(node.getName()) || nodeInCommand.equals(node.getId());
                    })) continue;
                    e = ExceptionsHelper.useOrSuppress(e, new IllegalArgumentException("No data for shard [" + command.shardId() + "] of index [" + index + "] found on node [" + command.node() + ']'));
                }
            }
            if (e == null) {
                this.submitStateUpdate(request, listener);
            } else {
                listener.onFailure(e);
            }
        }, listener::onFailure), IndicesShardStoresResponse::new));
    }

    private void submitStateUpdate(ClusterRerouteRequest request, ActionListener<ClusterRerouteResponse> listener) {
        this.clusterService.submitStateUpdateTask("cluster_reroute (api)", new ClusterRerouteResponseAckedClusterStateUpdateTask(this.logger, this.allocationService, request, ActionListener.wrap(response -> {
            if (!request.dryRun()) {
                response.getExplanations().getYesDecisionMessages().forEach(this.logger::info);
            }
            listener.onResponse((ClusterRerouteResponse)response);
        }, listener::onFailure)));
    }

    static class ClusterRerouteResponseAckedClusterStateUpdateTask
    extends AckedClusterStateUpdateTask<ClusterRerouteResponse> {
        private final ClusterRerouteRequest request;
        private final ActionListener<ClusterRerouteResponse> listener;
        private final Logger logger;
        private final AllocationService allocationService;
        private volatile ClusterState clusterStateToSend;
        private volatile RoutingExplanations explanations;

        ClusterRerouteResponseAckedClusterStateUpdateTask(Logger logger, AllocationService allocationService, ClusterRerouteRequest request, ActionListener<ClusterRerouteResponse> listener) {
            super(Priority.IMMEDIATE, request, listener);
            this.request = request;
            this.listener = listener;
            this.logger = logger;
            this.allocationService = allocationService;
        }

        @Override
        protected ClusterRerouteResponse newResponse(boolean acknowledged) {
            return new ClusterRerouteResponse(acknowledged, this.clusterStateToSend, this.explanations);
        }

        @Override
        public void onAckTimeout() {
            this.listener.onResponse(new ClusterRerouteResponse(false, this.clusterStateToSend, new RoutingExplanations()));
        }

        @Override
        public void onFailure(String source, Exception e) {
            this.logger.debug(() -> new ParameterizedMessage("failed to perform [{}]", (Object)source), (Throwable)e);
            super.onFailure(source, e);
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            AllocationService.CommandsResult commandsResult = this.allocationService.reroute(currentState, this.request.getCommands(), this.request.explain(), this.request.isRetryFailed());
            this.clusterStateToSend = commandsResult.getClusterState();
            this.explanations = commandsResult.explanations();
            if (this.request.dryRun()) {
                return currentState;
            }
            return commandsResult.getClusterState();
        }
    }
}

