/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.indices.mapping.get;

import conductor.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import conductor.org.elasticsearch.action.ActionResponse;
import conductor.org.elasticsearch.cluster.metadata.MappingMetaData;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.collect.ImmutableOpenMap;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import java.io.IOException;
import java.util.Map;

public class GetMappingsResponse
extends ActionResponse
implements ToXContentFragment {
    private static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    private static final ObjectParser<GetMappingsResponse, Void> PARSER = new ObjectParser("get-mappings", false, GetMappingsResponse::new);
    private ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> mappings = ImmutableOpenMap.of();

    public GetMappingsResponse(ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> mappings) {
        this.mappings = mappings;
    }

    GetMappingsResponse() {
    }

    public ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> mappings() {
        return this.mappings;
    }

    public ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> getMappings() {
        return this.mappings();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        ImmutableOpenMap.Builder indexMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            int valueSize = in.readVInt();
            ImmutableOpenMap.Builder<String, MappingMetaData> typeMapBuilder = ImmutableOpenMap.builder();
            for (int j = 0; j < valueSize; ++j) {
                typeMapBuilder.put(in.readString(), new MappingMetaData(in));
            }
            indexMapBuilder.put(key, typeMapBuilder.build());
        }
        this.mappings = indexMapBuilder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.mappings.size());
        for (ObjectObjectCursor<String, ImmutableOpenMap<String, MappingMetaData>> objectObjectCursor : this.mappings) {
            out.writeString((String)objectObjectCursor.key);
            out.writeVInt(((ImmutableOpenMap)objectObjectCursor.value).size());
            for (ObjectObjectCursor typeEntry : (ImmutableOpenMap)objectObjectCursor.value) {
                out.writeString((String)typeEntry.key);
                ((MappingMetaData)typeEntry.value).writeTo(out);
            }
        }
    }

    public static GetMappingsResponse fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        assert (parser.currentToken() == XContentParser.Token.START_OBJECT);
        Map<String, Object> parts = parser.map();
        ImmutableOpenMap.Builder builder = new ImmutableOpenMap.Builder();
        for (Map.Entry<String, Object> entry : parts.entrySet()) {
            String indexName = entry.getKey();
            assert (entry.getValue() instanceof Map) : "expected a map as type mapping, but got: " + entry.getValue().getClass();
            Map mapping = (Map)((Map)entry.getValue()).get(MAPPINGS.getPreferredName());
            ImmutableOpenMap.Builder<String, MappingMetaData> typeBuilder = new ImmutableOpenMap.Builder<String, MappingMetaData>();
            for (Map.Entry typeEntry : mapping.entrySet()) {
                String typeName = (String)typeEntry.getKey();
                assert (typeEntry.getValue() instanceof Map) : "expected a map as inner type mapping, but got: " + typeEntry.getValue().getClass();
                Map fieldMappings = (Map)typeEntry.getValue();
                MappingMetaData mmd = new MappingMetaData(typeName, fieldMappings);
                typeBuilder.put(typeName, mmd);
            }
            builder.put(indexName, typeBuilder.build());
        }
        return new GetMappingsResponse(builder.build());
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeTypeName = params.paramAsBoolean("include_type_name", true);
        for (ObjectObjectCursor<String, ImmutableOpenMap<String, MappingMetaData>> objectObjectCursor : this.getMappings()) {
            builder.startObject((String)objectObjectCursor.key);
            if (!includeTypeName) {
                MappingMetaData mappings = null;
                for (ObjectObjectCursor typeEntry : (ImmutableOpenMap)objectObjectCursor.value) {
                    if (((String)typeEntry.key).equals("_default_")) continue;
                    if (mappings != null) {
                        throw new IllegalArgumentException("Cannot use [include_type_name=false] on index [" + (String)objectObjectCursor.key + "] that has multiple mappings: " + ((ImmutableOpenMap)objectObjectCursor.value).keys());
                    }
                    mappings = (MappingMetaData)typeEntry.value;
                }
                if (mappings == null) {
                    builder.startObject(MAPPINGS.getPreferredName()).endObject();
                } else {
                    builder.field(MAPPINGS.getPreferredName(), mappings.sourceAsMap());
                }
            } else {
                builder.startObject(MAPPINGS.getPreferredName());
                for (ObjectObjectCursor typeEntry : (ImmutableOpenMap)objectObjectCursor.value) {
                    builder.field((String)typeEntry.key, ((MappingMetaData)typeEntry.value).sourceAsMap());
                }
                builder.endObject();
            }
            builder.endObject();
        }
        return builder;
    }

    public String toString() {
        return Strings.toString(this);
    }

    public int hashCode() {
        return this.mappings.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetMappingsResponse other = (GetMappingsResponse)obj;
        return this.mappings.equals(other.mappings);
    }
}

