/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.indices.recovery;

import conductor.org.elasticsearch.action.support.DefaultShardOperationFailedException;
import conductor.org.elasticsearch.action.support.broadcast.BroadcastResponse;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.indices.recovery.RecoveryState;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecoveryResponse
extends BroadcastResponse {
    private Map<String, List<RecoveryState>> shardRecoveryStates = new HashMap<String, List<RecoveryState>>();

    public RecoveryResponse() {
    }

    public RecoveryResponse(int totalShards, int successfulShards, int failedShards, Map<String, List<RecoveryState>> shardRecoveryStates, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.shardRecoveryStates = shardRecoveryStates;
    }

    public boolean hasRecoveries() {
        return this.shardRecoveryStates.size() > 0;
    }

    public Map<String, List<RecoveryState>> shardRecoveryStates() {
        return this.shardRecoveryStates;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.hasRecoveries()) {
            for (String index : this.shardRecoveryStates.keySet()) {
                List<RecoveryState> recoveryStates = this.shardRecoveryStates.get(index);
                if (recoveryStates == null || recoveryStates.size() == 0) continue;
                builder.startObject(index);
                builder.startArray("shards");
                for (RecoveryState recoveryState : recoveryStates) {
                    builder.startObject();
                    recoveryState.toXContent(builder, params);
                    builder.endObject();
                }
                builder.endArray();
                builder.endObject();
            }
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.shardRecoveryStates.size());
        for (Map.Entry<String, List<RecoveryState>> entry : this.shardRecoveryStates.entrySet()) {
            out.writeString(entry.getKey());
            out.writeVInt(entry.getValue().size());
            for (RecoveryState recoveryState : entry.getValue()) {
                recoveryState.writeTo(out);
            }
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            String s = in.readString();
            int listSize = in.readVInt();
            ArrayList<RecoveryState> list = new ArrayList<RecoveryState>(listSize);
            for (int j = 0; j < listSize; ++j) {
                list.add(RecoveryState.readRecoveryState(in));
            }
            this.shardRecoveryStates.put(s, list);
        }
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }
}

