/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.search;

import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.lucene.util.FixedBitSet;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.search.AbstractSearchAsyncAction;
import conductor.org.elasticsearch.action.search.InitialSearchPhase;
import conductor.org.elasticsearch.action.search.SearchActionListener;
import conductor.org.elasticsearch.action.search.SearchPhase;
import conductor.org.elasticsearch.action.search.SearchPhaseContext;
import conductor.org.elasticsearch.action.search.SearchRequest;
import conductor.org.elasticsearch.action.search.SearchResponse;
import conductor.org.elasticsearch.action.search.SearchShardIterator;
import conductor.org.elasticsearch.action.search.SearchTask;
import conductor.org.elasticsearch.action.search.SearchTransportService;
import conductor.org.elasticsearch.action.search.TransportSearchAction;
import conductor.org.elasticsearch.cluster.routing.GroupShardsIterator;
import conductor.org.elasticsearch.cluster.routing.ShardRouting;
import conductor.org.elasticsearch.search.SearchService;
import conductor.org.elasticsearch.search.internal.AliasFilter;
import conductor.org.elasticsearch.transport.Transport;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

final class CanMatchPreFilterSearchPhase
extends AbstractSearchAsyncAction<SearchService.CanMatchResponse> {
    private final Function<GroupShardsIterator<SearchShardIterator>, SearchPhase> phaseFactory;
    private final GroupShardsIterator<SearchShardIterator> shardsIts;

    CanMatchPreFilterSearchPhase(Logger logger, SearchTransportService searchTransportService, BiFunction<String, String, Transport.Connection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Map<String, Set<String>> indexRoutings, Executor executor, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator<SearchShardIterator> shardsIts, TransportSearchAction.SearchTimeProvider timeProvider, long clusterStateVersion, SearchTask task, Function<GroupShardsIterator<SearchShardIterator>, SearchPhase> phaseFactory, SearchResponse.Clusters clusters) {
        super("can_match", logger, searchTransportService, nodeIdToConnection, aliasFilter, concreteIndexBoosts, indexRoutings, executor, request, listener, shardsIts, timeProvider, clusterStateVersion, task, new BitSetSearchPhaseResults(shardsIts.size()), shardsIts.size(), clusters);
        this.phaseFactory = phaseFactory;
        this.shardsIts = shardsIts;
    }

    @Override
    protected void executePhaseOnShard(SearchShardIterator shardIt, ShardRouting shard, SearchActionListener<SearchService.CanMatchResponse> listener) {
        this.getSearchTransport().sendCanMatch(this.getConnection(shardIt.getClusterAlias(), shard.currentNodeId()), this.buildShardSearchRequest(shardIt), this.getTask(), listener);
    }

    @Override
    protected SearchPhase getNextPhase(InitialSearchPhase.SearchPhaseResults<SearchService.CanMatchResponse> results, SearchPhaseContext context) {
        return this.phaseFactory.apply(this.getIterator((BitSetSearchPhaseResults)results, this.shardsIts));
    }

    private GroupShardsIterator<SearchShardIterator> getIterator(BitSetSearchPhaseResults results, GroupShardsIterator<SearchShardIterator> shardsIts) {
        int cardinality = results.getNumPossibleMatches();
        FixedBitSet possibleMatches = results.getPossibleMatches();
        if (cardinality == 0) {
            possibleMatches.set(0);
        }
        int i = 0;
        for (SearchShardIterator iter : shardsIts) {
            if (possibleMatches.get(i++)) {
                iter.reset();
                continue;
            }
            iter.resetAndSkip();
        }
        return shardsIts;
    }

    private static final class BitSetSearchPhaseResults
    extends InitialSearchPhase.SearchPhaseResults<SearchService.CanMatchResponse> {
        private final FixedBitSet possibleMatches;
        private int numPossibleMatches;

        BitSetSearchPhaseResults(int size) {
            super(size);
            this.possibleMatches = new FixedBitSet(size);
        }

        @Override
        void consumeResult(SearchService.CanMatchResponse result) {
            if (result.canMatch()) {
                this.consumeShardFailure(result.getShardIndex());
            }
        }

        @Override
        boolean hasResult(int shardIndex) {
            return false;
        }

        @Override
        synchronized void consumeShardFailure(int shardIndex) {
            this.possibleMatches.set(shardIndex);
            ++this.numPossibleMatches;
        }

        synchronized int getNumPossibleMatches() {
            return this.numPossibleMatches;
        }

        synchronized FixedBitSet getPossibleMatches() {
            return this.possibleMatches;
        }

        @Override
        Stream<SearchService.CanMatchResponse> getSuccessfulResults() {
            return Stream.empty();
        }
    }
}

