/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client;

import conductor.org.apache.http.HttpEntity;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.support.master.AcknowledgedResponse;
import conductor.org.elasticsearch.client.LicenseRequestConverters;
import conductor.org.elasticsearch.client.RequestOptions;
import conductor.org.elasticsearch.client.Response;
import conductor.org.elasticsearch.client.RestHighLevelClient;
import conductor.org.elasticsearch.client.Validatable;
import conductor.org.elasticsearch.client.license.DeleteLicenseRequest;
import conductor.org.elasticsearch.client.license.GetBasicStatusResponse;
import conductor.org.elasticsearch.client.license.GetLicenseRequest;
import conductor.org.elasticsearch.client.license.GetLicenseResponse;
import conductor.org.elasticsearch.client.license.GetTrialStatusResponse;
import conductor.org.elasticsearch.client.license.PutLicenseRequest;
import conductor.org.elasticsearch.client.license.PutLicenseResponse;
import conductor.org.elasticsearch.client.license.StartBasicRequest;
import conductor.org.elasticsearch.client.license.StartBasicResponse;
import conductor.org.elasticsearch.client.license.StartTrialRequest;
import conductor.org.elasticsearch.client.license.StartTrialResponse;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.Streams;
import conductor.org.elasticsearch.common.xcontent.DeprecationHandler;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentFactory;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;

public final class LicenseClient {
    private final RestHighLevelClient restHighLevelClient;

    LicenseClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public PutLicenseResponse putLicense(PutLicenseRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, LicenseRequestConverters::putLicense, options, PutLicenseResponse::fromXContent, Collections.emptySet());
    }

    public void putLicenseAsync(PutLicenseRequest request, RequestOptions options, ActionListener<PutLicenseResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, LicenseRequestConverters::putLicense, options, PutLicenseResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetLicenseResponse getLicense(GetLicenseRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequest(request, LicenseRequestConverters::getLicense, options, response -> new GetLicenseResponse(LicenseClient.convertResponseToJson(response)), Collections.emptySet());
    }

    public void getLicenseAsync(GetLicenseRequest request, RequestOptions options, ActionListener<GetLicenseResponse> listener) {
        this.restHighLevelClient.performRequestAsync(request, LicenseRequestConverters::getLicense, options, response -> new GetLicenseResponse(LicenseClient.convertResponseToJson(response)), listener, Collections.emptySet());
    }

    public AcknowledgedResponse deleteLicense(DeleteLicenseRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, LicenseRequestConverters::deleteLicense, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void deleteLicenseAsync(DeleteLicenseRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, LicenseRequestConverters::deleteLicense, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public StartTrialResponse startTrial(StartTrialRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, LicenseRequestConverters::startTrial, options, StartTrialResponse::fromXContent, Collections.singleton(403));
    }

    public void startTrialAsync(StartTrialRequest request, RequestOptions options, ActionListener<StartTrialResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, LicenseRequestConverters::startTrial, options, StartTrialResponse::fromXContent, listener, Collections.singleton(403));
    }

    public StartBasicResponse startBasic(StartBasicRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, LicenseRequestConverters::startBasic, options, StartBasicResponse::fromXContent, Collections.emptySet());
    }

    public void startBasicAsync(StartBasicRequest request, RequestOptions options, ActionListener<StartBasicResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, LicenseRequestConverters::startBasic, options, StartBasicResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetTrialStatusResponse getTrialStatus(RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(Validatable.EMPTY, request -> LicenseRequestConverters.getLicenseTrialStatus(), options, GetTrialStatusResponse::fromXContent, Collections.emptySet());
    }

    public GetBasicStatusResponse getBasicStatus(RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(Validatable.EMPTY, request -> LicenseRequestConverters.getLicenseBasicStatus(), options, GetBasicStatusResponse::fromXContent, Collections.emptySet());
    }

    static String convertResponseToJson(Response response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            throw new IllegalStateException("Response body expected but not returned");
        }
        if (entity.getContentType() == null) {
            throw new IllegalStateException("Elasticsearch didn't return the [Content-Type] header, unable to parse response body");
        }
        XContentType xContentType = XContentType.fromMediaTypeOrFormat(entity.getContentType().getValue());
        if (xContentType == null) {
            throw new IllegalStateException("Unsupported Content-Type: " + entity.getContentType().getValue());
        }
        if (xContentType == XContentType.JSON) {
            return Streams.copyToString(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
        }
        try (InputStream stream = response.getEntity().getContent();){
            String string;
            block16: {
                XContentParser parser = XContentFactory.xContent(xContentType).createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, stream);
                try {
                    parser.nextToken();
                    XContentBuilder builder = XContentFactory.jsonBuilder();
                    builder.copyCurrentStructure(parser);
                    string = Strings.toString(builder);
                    if (parser == null) break block16;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return string;
        }
    }
}

