/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.security;

import conductor.org.elasticsearch.client.security.support.expressiondsl.RoleMapperExpression;
import conductor.org.elasticsearch.client.security.support.expressiondsl.parser.RoleMapperExpressionParser;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ExpressionRoleMapping {
    static final ConstructingObjectParser<ExpressionRoleMapping, String> PARSER = new ConstructingObjectParser<ExpressionRoleMapping, String>("role-mapping", true, (args, name) -> new ExpressionRoleMapping((String)name, (RoleMapperExpression)args[0], (List)args[1], (Map)args[2], (Boolean)args[3]));
    private final String name;
    private final RoleMapperExpression expression;
    private final List<String> roles;
    private final Map<String, Object> metadata;
    private final boolean enabled;

    public ExpressionRoleMapping(String name, RoleMapperExpression expr, List<String> roles, Map<String, Object> metadata, boolean enabled) {
        this.name = name;
        this.expression = expr;
        this.roles = Collections.unmodifiableList(roles);
        this.metadata = metadata == null ? Collections.emptyMap() : Collections.unmodifiableMap(metadata);
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public RoleMapperExpression getExpression() {
        return this.expression;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionRoleMapping other = (ExpressionRoleMapping)obj;
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.roles == null ? other.roles != null : !this.roles.equals(other.roles));
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> RoleMapperExpressionParser.fromXContent(parser), Fields.RULES, ObjectParser.ValueType.OBJECT);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), Fields.ROLES);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), XContentParser::map, Fields.METADATA, ObjectParser.ValueType.OBJECT);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), Fields.ENABLED);
    }

    public static interface Fields {
        public static final ParseField ROLES = new ParseField("roles", new String[0]);
        public static final ParseField ENABLED = new ParseField("enabled", new String[0]);
        public static final ParseField RULES = new ParseField("rules", new String[0]);
        public static final ParseField METADATA = new ParseField("metadata", new String[0]);
    }
}

