/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.breaker;

import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.rest.RestStatus;
import java.io.IOException;

public class CircuitBreakingException
extends ElasticsearchException {
    private final long bytesWanted;
    private final long byteLimit;

    public CircuitBreakingException(String message) {
        super(message, new Object[0]);
        this.bytesWanted = 0L;
        this.byteLimit = 0L;
    }

    public CircuitBreakingException(StreamInput in) throws IOException {
        super(in);
        this.byteLimit = in.readLong();
        this.bytesWanted = in.readLong();
    }

    public CircuitBreakingException(String message, long bytesWanted, long byteLimit) {
        super(message, new Object[0]);
        this.bytesWanted = bytesWanted;
        this.byteLimit = byteLimit;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.byteLimit);
        out.writeLong(this.bytesWanted);
    }

    public long getBytesWanted() {
        return this.bytesWanted;
    }

    public long getByteLimit() {
        return this.byteLimit;
    }

    @Override
    public RestStatus status() {
        return RestStatus.SERVICE_UNAVAILABLE;
    }

    @Override
    protected void metadataToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("bytes_wanted", this.bytesWanted);
        builder.field("bytes_limit", this.byteLimit);
    }
}

