/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.lucene.search;

import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.IndexReaderContext;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.index.Terms;
import conductor.org.apache.lucene.index.TermsEnum;
import conductor.org.apache.lucene.queries.SpanMatchNoDocsQuery;
import conductor.org.apache.lucene.search.BooleanQuery;
import conductor.org.apache.lucene.search.MultiTermQuery;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import conductor.org.apache.lucene.search.spans.SpanOrQuery;
import conductor.org.apache.lucene.search.spans.SpanQuery;
import conductor.org.apache.lucene.search.spans.SpanTermQuery;
import conductor.org.apache.lucene.util.AttributeSource;
import conductor.org.apache.lucene.util.BytesRef;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;

public class SpanBooleanQueryRewriteWithMaxClause
extends SpanMultiTermQueryWrapper.SpanRewriteMethod {
    private final int maxExpansions;
    private final boolean hardLimit;

    public SpanBooleanQueryRewriteWithMaxClause() {
        this(BooleanQuery.getMaxClauseCount(), true);
    }

    public SpanBooleanQueryRewriteWithMaxClause(int maxExpansions, boolean hardLimit) {
        this.maxExpansions = maxExpansions;
        this.hardLimit = hardLimit;
    }

    public int getMaxExpansions() {
        return this.maxExpansions;
    }

    public boolean isHardLimit() {
        return this.hardLimit;
    }

    @Override
    public SpanQuery rewrite(IndexReader reader, MultiTermQuery query) throws IOException {
        MultiTermQuery.RewriteMethod delegate = new MultiTermQuery.RewriteMethod(){

            @Override
            public Query rewrite(IndexReader reader, MultiTermQuery query) throws IOException {
                Collection<SpanQuery> queries = this.collectTerms(reader, query);
                if (queries.size() == 0) {
                    return new SpanMatchNoDocsQuery(query.getField(), "no expansion found for " + query.toString());
                }
                if (queries.size() == 1) {
                    return queries.iterator().next();
                }
                return new SpanOrQuery(queries.toArray(new SpanQuery[0]));
            }

            private Collection<SpanQuery> collectTerms(IndexReader reader, MultiTermQuery query) throws IOException {
                HashSet<SpanQuery> queries = new HashSet<SpanQuery>();
                IndexReaderContext topReaderContext = reader.getContext();
                for (LeafReaderContext context : topReaderContext.leaves()) {
                    BytesRef bytes;
                    Terms terms = context.reader().terms(query.getField());
                    if (terms == null) continue;
                    TermsEnum termsEnum = this.getTermsEnum(query, terms, new AttributeSource());
                    assert (termsEnum != null);
                    if (termsEnum == TermsEnum.EMPTY) continue;
                    while ((bytes = termsEnum.next()) != null) {
                        if (queries.size() >= SpanBooleanQueryRewriteWithMaxClause.this.maxExpansions) {
                            if (SpanBooleanQueryRewriteWithMaxClause.this.hardLimit) {
                                throw new RuntimeException("[" + query.toString() + " ] exceeds maxClauseCount [ Boolean maxClauseCount is set to " + BooleanQuery.getMaxClauseCount() + "]");
                            }
                            return queries;
                        }
                        queries.add(new SpanTermQuery(new Term(query.getField(), bytes)));
                    }
                }
                return queries;
            }
        };
        return (SpanQuery)delegate.rewrite(reader, query);
    }
}

