/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.xcontent;

import conductor.org.elasticsearch.common.ParsingException;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.XContentLocation;
import java.io.IOException;
import java.util.Objects;

public class UnknownNamedObjectException
extends ParsingException {
    private final String categoryClass;
    private final String name;

    public UnknownNamedObjectException(XContentLocation contentLocation, Class<?> categoryClass, String name) {
        super(contentLocation, "Unknown " + categoryClass.getSimpleName() + " [" + name + "]", new Object[0]);
        this.categoryClass = Objects.requireNonNull(categoryClass, "categoryClass is required").getName();
        this.name = Objects.requireNonNull(name, "name is required");
    }

    public UnknownNamedObjectException(StreamInput in) throws IOException {
        super(in);
        this.categoryClass = in.readString();
        this.name = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.categoryClass);
        out.writeString(this.name);
    }

    public String getCategoryClass() {
        return this.categoryClass;
    }

    public String getName() {
        return this.name;
    }
}

