/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.admin.cluster;

import conductor.org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import conductor.org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.settings.SettingsFilter;
import conductor.org.elasticsearch.common.util.set.Sets;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.RestChannel;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.action.RestActions;
import java.io.IOException;
import java.util.Set;

public class RestNodesInfoAction
extends BaseRestHandler {
    private static final Set<String> ALLOWED_METRICS = Sets.newHashSet("http", "ingest", "indices", "jvm", "os", "plugins", "process", "settings", "thread_pool", "transport");
    private final SettingsFilter settingsFilter;

    public RestNodesInfoAction(Settings settings, RestController controller, SettingsFilter settingsFilter) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}/{metrics}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}/info/{metrics}", this);
        this.settingsFilter = settingsFilter;
    }

    @Override
    public String getName() {
        return "nodes_info_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        Set<String> metrics;
        String[] nodeIds;
        if (request.hasParam("nodeId") && !request.hasParam("metrics")) {
            Set<String> metricsOrNodeIds = Strings.tokenizeByCommaToSet(request.param("nodeId", "_all"));
            boolean isMetricsOnly = ALLOWED_METRICS.containsAll(metricsOrNodeIds);
            if (isMetricsOnly) {
                nodeIds = new String[]{"_all"};
                metrics = metricsOrNodeIds;
            } else {
                nodeIds = metricsOrNodeIds.toArray(new String[0]);
                metrics = Sets.newHashSet("_all");
            }
        } else {
            nodeIds = Strings.splitStringByCommaToArray(request.param("nodeId", "_all"));
            metrics = Strings.tokenizeByCommaToSet(request.param("metrics", "_all"));
        }
        NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(nodeIds);
        nodesInfoRequest.timeout(request.param("timeout"));
        if (metrics.size() == 1 && metrics.contains("_all")) {
            nodesInfoRequest.all();
        } else {
            nodesInfoRequest.clear();
            nodesInfoRequest.settings(metrics.contains("settings"));
            nodesInfoRequest.os(metrics.contains("os"));
            nodesInfoRequest.process(metrics.contains("process"));
            nodesInfoRequest.jvm(metrics.contains("jvm"));
            nodesInfoRequest.threadPool(metrics.contains("thread_pool"));
            nodesInfoRequest.transport(metrics.contains("transport"));
            nodesInfoRequest.http(metrics.contains("http"));
            nodesInfoRequest.plugins(metrics.contains("plugins"));
            nodesInfoRequest.ingest(metrics.contains("ingest"));
            nodesInfoRequest.indices(metrics.contains("indices"));
        }
        this.settingsFilter.addFilterSettingParams(request);
        return channel -> client.admin().cluster().nodesInfo(nodesInfoRequest, new RestActions.NodesResponseRestListener<NodesInfoResponse>((RestChannel)channel));
    }

    @Override
    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }
}

