/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.cat;

import conductor.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import conductor.org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import conductor.org.elasticsearch.cluster.metadata.MetaData;
import conductor.org.elasticsearch.common.Table;
import conductor.org.elasticsearch.common.regex.Regex;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.RestResponse;
import conductor.org.elasticsearch.rest.action.RestResponseListener;
import conductor.org.elasticsearch.rest.action.cat.AbstractCatAction;
import conductor.org.elasticsearch.rest.action.cat.RestTable;

public class RestTemplatesAction
extends AbstractCatAction {
    public RestTemplatesAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_cat/templates", this);
        controller.registerHandler(RestRequest.Method.GET, "/_cat/templates/{name}", this);
    }

    @Override
    public String getName() {
        return "cat_templates_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/templates\n");
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        final String matchPattern = request.hasParam("name") ? request.param("name") : null;
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.clear().metaData(true);
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.masterNodeTimeout(request.paramAsTime("master_timeout", clusterStateRequest.masterNodeTimeout()));
        return channel -> client.admin().cluster().state(clusterStateRequest, (ActionListener<ClusterStateResponse>)new RestResponseListener<ClusterStateResponse>(channel){

            @Override
            public RestResponse buildResponse(ClusterStateResponse clusterStateResponse) throws Exception {
                return RestTable.buildResponse(RestTemplatesAction.this.buildTable(request, clusterStateResponse, matchPattern), this.channel);
            }
        });
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell("name", "alias:n;desc:template name");
        table.addCell("index_patterns", "alias:t;desc:template index patterns");
        table.addCell("order", "alias:o;desc:template application order number");
        table.addCell("version", "alias:v;desc:version");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, ClusterStateResponse clusterStateResponse, String patternString) {
        Table table = this.getTableWithHeader(request);
        MetaData metadata = clusterStateResponse.getState().metaData();
        for (ObjectObjectCursor<String, IndexTemplateMetaData> objectObjectCursor : metadata.templates()) {
            IndexTemplateMetaData indexData = (IndexTemplateMetaData)objectObjectCursor.value;
            if (patternString != null && !Regex.simpleMatch(patternString, indexData.name())) continue;
            table.startRow();
            table.addCell(indexData.name());
            table.addCell("[" + String.join((CharSequence)", ", indexData.patterns()) + "]");
            table.addCell(indexData.getOrder());
            table.addCell(indexData.getVersion());
            table.endRow();
        }
        return table;
    }
}

