/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.script;

import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import java.io.IOException;
import java.util.Locale;

public enum ScriptType implements Writeable
{
    INLINE(0, new ParseField("source", "inline"), false),
    STORED(1, new ParseField("id", "stored"), false);

    private final int id;
    private final ParseField parseField;
    private final boolean defaultEnabled;

    public static ScriptType readFrom(StreamInput in) throws IOException {
        int id = in.readVInt();
        if (ScriptType.STORED.id == id) {
            return STORED;
        }
        if (ScriptType.INLINE.id == id) {
            return INLINE;
        }
        throw new IllegalStateException("Error reading ScriptType id [" + id + "] from stream, expected one of [" + ScriptType.STORED.id + " [" + ScriptType.STORED.parseField.getPreferredName() + "], " + ScriptType.INLINE.id + " [" + ScriptType.INLINE.parseField.getPreferredName() + "]]");
    }

    private ScriptType(int id, ParseField parseField, boolean defaultEnabled) {
        this.id = id;
        this.parseField = parseField;
        this.defaultEnabled = defaultEnabled;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.id);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public ParseField getParseField() {
        return this.parseField;
    }

    public boolean isDefaultEnabled() {
        return this.defaultEnabled;
    }

    public String toString() {
        return this.getName();
    }
}

