/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.internal;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.search.SearchRequest;
import conductor.org.elasticsearch.action.search.SearchType;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.bytes.BytesArray;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.io.stream.BytesStreamOutput;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.index.query.QueryRewriteContext;
import conductor.org.elasticsearch.index.query.Rewriteable;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.search.Scroll;
import conductor.org.elasticsearch.search.builder.SearchSourceBuilder;
import conductor.org.elasticsearch.search.internal.AliasFilter;
import conductor.org.elasticsearch.search.internal.ShardSearchRequest;
import java.io.IOException;
import java.util.Optional;

public class ShardSearchLocalRequest
implements ShardSearchRequest {
    private String clusterAlias;
    private ShardId shardId;
    private int numberOfShards;
    private SearchType searchType;
    private Scroll scroll;
    private String[] types = Strings.EMPTY_ARRAY;
    private AliasFilter aliasFilter;
    private float indexBoost;
    private SearchSourceBuilder source;
    private Boolean requestCache;
    private long nowInMillis;
    private boolean allowPartialSearchResults;
    private String[] indexRoutings = Strings.EMPTY_ARRAY;
    private String preference;
    private boolean profile;

    ShardSearchLocalRequest() {
    }

    ShardSearchLocalRequest(SearchRequest searchRequest, ShardId shardId, int numberOfShards, AliasFilter aliasFilter, float indexBoost, long nowInMillis, @Nullable String clusterAlias, String[] indexRoutings) {
        this(shardId, numberOfShards, searchRequest.searchType(), searchRequest.source(), searchRequest.types(), searchRequest.requestCache(), aliasFilter, indexBoost, searchRequest.allowPartialSearchResults(), indexRoutings, searchRequest.preference());
        assert (searchRequest.allowPartialSearchResults() != null);
        this.scroll = searchRequest.scroll();
        this.nowInMillis = nowInMillis;
        this.clusterAlias = clusterAlias;
    }

    public ShardSearchLocalRequest(ShardId shardId, String[] types, long nowInMillis, AliasFilter aliasFilter) {
        this.types = types;
        this.nowInMillis = nowInMillis;
        this.aliasFilter = aliasFilter;
        this.shardId = shardId;
        this.indexBoost = 1.0f;
    }

    public ShardSearchLocalRequest(ShardId shardId, int numberOfShards, SearchType searchType, SearchSourceBuilder source, String[] types, Boolean requestCache, AliasFilter aliasFilter, float indexBoost, boolean allowPartialSearchResults, String[] indexRoutings, String preference) {
        this.shardId = shardId;
        this.numberOfShards = numberOfShards;
        this.searchType = searchType;
        this.source = source;
        this.types = types;
        this.requestCache = requestCache;
        this.aliasFilter = aliasFilter;
        this.indexBoost = indexBoost;
        this.allowPartialSearchResults = allowPartialSearchResults;
        this.indexRoutings = indexRoutings;
        this.preference = preference;
    }

    @Override
    public ShardId shardId() {
        return this.shardId;
    }

    @Override
    public String[] types() {
        return this.types;
    }

    @Override
    public SearchSourceBuilder source() {
        return this.source;
    }

    @Override
    public AliasFilter getAliasFilter() {
        return this.aliasFilter;
    }

    @Override
    public void setAliasFilter(AliasFilter aliasFilter) {
        this.aliasFilter = aliasFilter;
    }

    @Override
    public void source(SearchSourceBuilder source) {
        this.source = source;
    }

    @Override
    public int numberOfShards() {
        return this.numberOfShards;
    }

    @Override
    public SearchType searchType() {
        return this.searchType;
    }

    @Override
    public float indexBoost() {
        return this.indexBoost;
    }

    @Override
    public long nowInMillis() {
        return this.nowInMillis;
    }

    @Override
    public Boolean requestCache() {
        return this.requestCache;
    }

    @Override
    public Boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    @Override
    public Scroll scroll() {
        return this.scroll;
    }

    @Override
    public String[] indexRoutings() {
        return this.indexRoutings;
    }

    @Override
    public String preference() {
        return this.preference;
    }

    @Override
    public void setProfile(boolean profile) {
        this.profile = profile;
    }

    @Override
    public boolean isProfile() {
        return this.profile;
    }

    void setSearchType(SearchType type) {
        this.searchType = type;
    }

    protected void innerReadFrom(StreamInput in) throws IOException {
        Optional<SearchSourceBuilder.IndexBoost> boost;
        this.shardId = ShardId.readShardId(in);
        this.searchType = SearchType.fromId(in.readByte());
        this.numberOfShards = in.readVInt();
        this.scroll = in.readOptionalWriteable(Scroll::new);
        this.source = in.readOptionalWriteable(SearchSourceBuilder::new);
        this.types = in.readStringArray();
        this.aliasFilter = new AliasFilter(in);
        this.indexBoost = in.getVersion().onOrAfter(Version.V_5_2_0) ? in.readFloat() : (this.source != null ? ((boost = this.source.indexBoosts().stream().filter(ib -> ib.getIndex().equals(this.shardId.getIndexName())).findFirst()).isPresent() ? boost.get().getBoost() : 1.0f) : 1.0f);
        this.nowInMillis = in.readVLong();
        this.requestCache = in.readOptionalBoolean();
        if (in.getVersion().onOrAfter(Version.V_5_6_0)) {
            this.clusterAlias = in.readOptionalString();
        }
        if (in.getVersion().onOrAfter(Version.V_6_3_0)) {
            this.allowPartialSearchResults = in.readOptionalBoolean();
        }
        if (in.getVersion().onOrAfter(Version.V_6_4_0)) {
            this.indexRoutings = in.readStringArray();
            this.preference = in.readOptionalString();
        } else {
            this.indexRoutings = Strings.EMPTY_ARRAY;
            this.preference = null;
        }
    }

    protected void innerWriteTo(StreamOutput out, boolean asKey) throws IOException {
        this.shardId.writeTo(out);
        out.writeByte(this.searchType.id());
        if (!asKey) {
            out.writeVInt(this.numberOfShards);
        }
        out.writeOptionalWriteable(this.scroll);
        out.writeOptionalWriteable(this.source);
        out.writeStringArray(this.types);
        this.aliasFilter.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_5_2_0)) {
            out.writeFloat(this.indexBoost);
        }
        if (!asKey) {
            out.writeVLong(this.nowInMillis);
        }
        out.writeOptionalBoolean(this.requestCache);
        if (out.getVersion().onOrAfter(Version.V_5_6_0)) {
            out.writeOptionalString(this.clusterAlias);
        }
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            out.writeOptionalBoolean(this.allowPartialSearchResults);
        }
        if (!asKey && out.getVersion().onOrAfter(Version.V_6_4_0)) {
            out.writeStringArray(this.indexRoutings);
            out.writeOptionalString(this.preference);
        }
    }

    @Override
    public BytesReference cacheKey() throws IOException {
        BytesStreamOutput out = new BytesStreamOutput();
        this.innerWriteTo(out, true);
        return new BytesArray(out.bytes().toBytesRef(), true);
    }

    @Override
    public String getClusterAlias() {
        return this.clusterAlias;
    }

    @Override
    public Rewriteable<Rewriteable> getRewriteable() {
        return new RequestRewritable(this);
    }

    static class RequestRewritable
    implements Rewriteable<Rewriteable> {
        final ShardSearchRequest request;

        RequestRewritable(ShardSearchRequest request) {
            this.request = request;
        }

        @Override
        public Rewriteable rewrite(QueryRewriteContext ctx) throws IOException {
            SearchSourceBuilder newSource = this.request.source() == null ? null : Rewriteable.rewrite(this.request.source(), ctx);
            AliasFilter newAliasFilter = Rewriteable.rewrite(this.request.getAliasFilter(), ctx);
            if (newSource == this.request.source() && newAliasFilter == this.request.getAliasFilter()) {
                return this;
            }
            this.request.source(newSource);
            this.request.setAliasFilter(newAliasFilter);
            return new RequestRewritable(this.request);
        }
    }
}

