/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.http.impl.nio.codecs;

import conductor.org.apache.http.HttpRequest;
import conductor.org.apache.http.HttpRequestFactory;
import conductor.org.apache.http.annotation.Contract;
import conductor.org.apache.http.annotation.ThreadingBehavior;
import conductor.org.apache.http.config.MessageConstraints;
import conductor.org.apache.http.impl.DefaultHttpRequestFactory;
import conductor.org.apache.http.impl.nio.codecs.DefaultHttpRequestParser;
import conductor.org.apache.http.message.BasicLineParser;
import conductor.org.apache.http.message.LineParser;
import conductor.org.apache.http.nio.NHttpMessageParser;
import conductor.org.apache.http.nio.NHttpMessageParserFactory;
import conductor.org.apache.http.nio.reactor.SessionInputBuffer;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestParserFactory
implements NHttpMessageParserFactory<HttpRequest> {
    public static final DefaultHttpRequestParserFactory INSTANCE = new DefaultHttpRequestParserFactory();
    private final LineParser lineParser;
    private final HttpRequestFactory requestFactory;

    public DefaultHttpRequestParserFactory(LineParser lineParser, HttpRequestFactory requestFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParserFactory() {
        this(null, null);
    }

    @Override
    public NHttpMessageParser<HttpRequest> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpRequestParser(buffer, this.lineParser, this.requestFactory, constraints);
    }
}

