/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.index;

import conductor.org.apache.lucene.codecs.FieldsConsumer;
import conductor.org.apache.lucene.index.DocumentsWriterPerThread;
import conductor.org.apache.lucene.index.FieldInfo;
import conductor.org.apache.lucene.index.FieldInvertState;
import conductor.org.apache.lucene.index.Fields;
import conductor.org.apache.lucene.index.FreqProxFields;
import conductor.org.apache.lucene.index.FreqProxTermsWriterPerField;
import conductor.org.apache.lucene.index.FrozenBufferedUpdates;
import conductor.org.apache.lucene.index.IndexOptions;
import conductor.org.apache.lucene.index.SegmentWriteState;
import conductor.org.apache.lucene.index.Sorter;
import conductor.org.apache.lucene.index.SortingLeafReader;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.index.TermsHash;
import conductor.org.apache.lucene.index.TermsHashPerField;
import conductor.org.apache.lucene.search.DocIdSetIterator;
import conductor.org.apache.lucene.util.CollectionUtil;
import conductor.org.apache.lucene.util.FixedBitSet;
import conductor.org.apache.lucene.util.IOUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

final class FreqProxTermsWriter
extends TermsHash {
    public FreqProxTermsWriter(DocumentsWriterPerThread docWriter, TermsHash termVectors) {
        super(docWriter, true, termVectors);
    }

    private void applyDeletes(SegmentWriteState state, Fields fields) throws IOException {
        if (state.segUpdates != null && state.segUpdates.deleteTerms.size() > 0) {
            Map<Term, Integer> segDeletes = state.segUpdates.deleteTerms;
            ArrayList<Term> deleteTerms = new ArrayList<Term>(segDeletes.keySet());
            Collections.sort(deleteTerms);
            FrozenBufferedUpdates.TermDocsIterator iterator = new FrozenBufferedUpdates.TermDocsIterator(fields, true);
            for (Term deleteTerm : deleteTerms) {
                int doc;
                DocIdSetIterator postings = iterator.nextTerm(deleteTerm.field(), deleteTerm.bytes());
                if (postings == null) continue;
                int delDocLimit = segDeletes.get(deleteTerm);
                assert (delDocLimit < Integer.MAX_VALUE);
                while ((doc = postings.nextDoc()) < delDocLimit) {
                    if (state.liveDocs == null) {
                        state.liveDocs = new FixedBitSet(state.segmentInfo.maxDoc());
                        state.liveDocs.set(0, state.segmentInfo.maxDoc());
                    }
                    if (!state.liveDocs.get(doc)) continue;
                    ++state.delCountOnFlush;
                    state.liveDocs.clear(doc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(Map<String, TermsHashPerField> fieldsToFlush, SegmentWriteState state, Sorter.DocMap sortMap) throws IOException {
        block8: {
            FieldsConsumer consumer;
            block7: {
                super.flush(fieldsToFlush, state, sortMap);
                ArrayList<FreqProxTermsWriterPerField> allFields = new ArrayList<FreqProxTermsWriterPerField>();
                for (TermsHashPerField f : fieldsToFlush.values()) {
                    FreqProxTermsWriterPerField perField = (FreqProxTermsWriterPerField)f;
                    if (perField.bytesHash.size() <= 0) continue;
                    perField.sortPostings();
                    assert (perField.fieldInfo.getIndexOptions() != IndexOptions.NONE);
                    allFields.add(perField);
                }
                CollectionUtil.introSort(allFields);
                Fields fields = new FreqProxFields(allFields);
                this.applyDeletes(state, fields);
                if (sortMap != null) {
                    fields = new SortingLeafReader.SortingFields(fields, state.fieldInfos, sortMap);
                }
                consumer = state.segmentInfo.getCodec().postingsFormat().fieldsConsumer(state);
                boolean success = false;
                try {
                    consumer.write(fields);
                    success = true;
                    if (!success) break block7;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(consumer);
                    } else {
                        IOUtils.closeWhileHandlingException(consumer);
                    }
                    throw throwable;
                }
                IOUtils.close(consumer);
                break block8;
            }
            IOUtils.closeWhileHandlingException(consumer);
        }
    }

    @Override
    public TermsHashPerField addField(FieldInvertState invertState, FieldInfo fieldInfo) {
        return new FreqProxTermsWriterPerField(invertState, this, fieldInfo, this.nextTermsHash.addField(invertState, fieldInfo));
    }
}

