/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.queryparser.flexible.standard.builders;

import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import conductor.org.apache.lucene.queryparser.flexible.core.nodes.FuzzyQueryNode;
import conductor.org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import conductor.org.apache.lucene.queryparser.flexible.standard.builders.StandardQueryBuilder;
import conductor.org.apache.lucene.search.FuzzyQuery;

public class FuzzyQueryNodeBuilder
implements StandardQueryBuilder {
    @Override
    public FuzzyQuery build(QueryNode queryNode) throws QueryNodeException {
        FuzzyQueryNode fuzzyNode = (FuzzyQueryNode)queryNode;
        String text = fuzzyNode.getTextAsString();
        int numEdits = FuzzyQuery.floatToEdits(fuzzyNode.getSimilarity(), text.codePointCount(0, text.length()));
        return new FuzzyQuery(new Term(fuzzyNode.getFieldAsString(), fuzzyNode.getTextAsString()), numEdits, fuzzyNode.getPrefixLength());
    }
}

