/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.spell;

import conductor.org.apache.lucene.search.spell.Dictionary;
import conductor.org.apache.lucene.search.suggest.InputIterator;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.BytesRefBuilder;
import conductor.org.apache.lucene.util.BytesRefIterator;
import conductor.org.apache.lucene.util.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

public class PlainTextDictionary
implements Dictionary {
    private BufferedReader in;

    public PlainTextDictionary(Path path) throws IOException {
        this.in = Files.newBufferedReader(path, StandardCharsets.UTF_8);
    }

    public PlainTextDictionary(InputStream dictFile) {
        this.in = new BufferedReader(IOUtils.getDecodingReader(dictFile, StandardCharsets.UTF_8));
    }

    public PlainTextDictionary(Reader reader) {
        this.in = new BufferedReader(reader);
    }

    @Override
    public InputIterator getEntryIterator() throws IOException {
        return new InputIterator.InputIteratorWrapper(new FileIterator());
    }

    final class FileIterator
    implements BytesRefIterator {
        private boolean done = false;
        private final BytesRefBuilder spare = new BytesRefBuilder();

        FileIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public BytesRef next() throws IOException {
            if (this.done) {
                return null;
            }
            boolean success = false;
            try {
                String line = PlainTextDictionary.this.in.readLine();
                if (line != null) {
                    this.spare.copyChars(line);
                    return this.spare.get();
                }
                this.done = true;
                IOUtils.close(PlainTextDictionary.this.in);
                return null;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException(PlainTextDictionary.this.in);
                throw throwable;
            }
        }
    }
}

