/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.indices.get;

import conductor.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import conductor.org.apache.lucene.util.CollectionUtil;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionResponse;
import conductor.org.elasticsearch.cluster.metadata.AliasMetaData;
import conductor.org.elasticsearch.cluster.metadata.MappingMetaData;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.collect.ImmutableOpenMap;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class GetIndexResponse
extends ActionResponse
implements ToXContentObject {
    private ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> mappings = ImmutableOpenMap.of();
    private ImmutableOpenMap<String, List<AliasMetaData>> aliases = ImmutableOpenMap.of();
    private ImmutableOpenMap<String, Settings> settings = ImmutableOpenMap.of();
    private ImmutableOpenMap<String, Settings> defaultSettings = ImmutableOpenMap.of();
    private String[] indices;

    public GetIndexResponse(String[] indices, ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> mappings, ImmutableOpenMap<String, List<AliasMetaData>> aliases, ImmutableOpenMap<String, Settings> settings, ImmutableOpenMap<String, Settings> defaultSettings) {
        this.indices = indices;
        Arrays.sort(indices);
        if (mappings != null) {
            this.mappings = mappings;
        }
        if (aliases != null) {
            this.aliases = aliases;
        }
        if (settings != null) {
            this.settings = settings;
        }
        if (defaultSettings != null) {
            this.defaultSettings = defaultSettings;
        }
    }

    GetIndexResponse() {
    }

    public String[] indices() {
        return this.indices;
    }

    public String[] getIndices() {
        return this.indices();
    }

    public ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> mappings() {
        return this.mappings;
    }

    public ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> getMappings() {
        return this.mappings();
    }

    public ImmutableOpenMap<String, List<AliasMetaData>> aliases() {
        return this.aliases;
    }

    public ImmutableOpenMap<String, List<AliasMetaData>> getAliases() {
        return this.aliases();
    }

    public ImmutableOpenMap<String, Settings> settings() {
        return this.settings;
    }

    public ImmutableOpenMap<String, Settings> defaultSettings() {
        return this.defaultSettings;
    }

    public ImmutableOpenMap<String, Settings> getSettings() {
        return this.settings();
    }

    public String getSetting(String index, String setting) {
        Settings indexSettings = this.settings.get(index);
        if (setting != null) {
            if (indexSettings != null && indexSettings.hasValue(setting)) {
                return indexSettings.get(setting);
            }
            Settings defaultIndexSettings = this.defaultSettings.get(index);
            if (defaultIndexSettings != null) {
                return defaultIndexSettings.get(setting);
            }
            return null;
        }
        return null;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
        int mappingsSize = in.readVInt();
        ImmutableOpenMap.Builder mappingsMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < mappingsSize; ++i) {
            String key = in.readString();
            int valueSize = in.readVInt();
            ImmutableOpenMap.Builder<String, MappingMetaData> mappingEntryBuilder = ImmutableOpenMap.builder();
            for (int j = 0; j < valueSize; ++j) {
                mappingEntryBuilder.put(in.readString(), new MappingMetaData(in));
            }
            mappingsMapBuilder.put(key, mappingEntryBuilder.build());
        }
        this.mappings = mappingsMapBuilder.build();
        int aliasesSize = in.readVInt();
        ImmutableOpenMap.Builder aliasesMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < aliasesSize; ++i) {
            String key = in.readString();
            int valueSize = in.readVInt();
            ArrayList<AliasMetaData> aliasEntryBuilder = new ArrayList<AliasMetaData>(valueSize);
            for (int j = 0; j < valueSize; ++j) {
                aliasEntryBuilder.add(new AliasMetaData(in));
            }
            aliasesMapBuilder.put(key, Collections.unmodifiableList(aliasEntryBuilder));
        }
        this.aliases = aliasesMapBuilder.build();
        int settingsSize = in.readVInt();
        ImmutableOpenMap.Builder<String, Settings> settingsMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < settingsSize; ++i) {
            String key = in.readString();
            settingsMapBuilder.put(key, Settings.readSettingsFromStream(in));
        }
        this.settings = settingsMapBuilder.build();
        ImmutableOpenMap.Builder<String, Settings> defaultSettingsMapBuilder = ImmutableOpenMap.builder();
        if (in.getVersion().onOrAfter(Version.V_6_4_0)) {
            int defaultSettingsSize = in.readVInt();
            for (int i = 0; i < defaultSettingsSize; ++i) {
                defaultSettingsMapBuilder.put(in.readString(), Settings.readSettingsFromStream(in));
            }
        }
        this.defaultSettings = defaultSettingsMapBuilder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        out.writeVInt(this.mappings.size());
        for (ObjectObjectCursor<String, ImmutableOpenMap<String, MappingMetaData>> objectObjectCursor : this.mappings) {
            out.writeString((String)objectObjectCursor.key);
            out.writeVInt(((ImmutableOpenMap)objectObjectCursor.value).size());
            for (ObjectObjectCursor mappingEntry : (ImmutableOpenMap)objectObjectCursor.value) {
                out.writeString((String)mappingEntry.key);
                ((MappingMetaData)mappingEntry.value).writeTo(out);
            }
        }
        out.writeVInt(this.aliases.size());
        for (ObjectObjectCursor objectObjectCursor : this.aliases) {
            out.writeString((String)objectObjectCursor.key);
            out.writeVInt(((List)objectObjectCursor.value).size());
            for (AliasMetaData aliasEntry : (List)objectObjectCursor.value) {
                aliasEntry.writeTo(out);
            }
        }
        out.writeVInt(this.settings.size());
        for (ObjectObjectCursor<String, Object> objectObjectCursor : this.settings) {
            out.writeString((String)objectObjectCursor.key);
            Settings.writeSettingsToStream((Settings)objectObjectCursor.value, out);
        }
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            out.writeVInt(this.defaultSettings.size());
            for (ObjectObjectCursor<String, Object> objectObjectCursor : this.defaultSettings) {
                out.writeString((String)objectObjectCursor.key);
                Settings.writeSettingsToStream((Settings)objectObjectCursor.value, out);
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (String index : this.indices) {
            builder.startObject(index);
            builder.startObject("aliases");
            List<AliasMetaData> indexAliases = this.aliases.get(index);
            if (indexAliases != null) {
                for (AliasMetaData alias : indexAliases) {
                    AliasMetaData.Builder.toXContent(alias, builder, params);
                }
            }
            builder.endObject();
            ImmutableOpenMap<String, MappingMetaData> indexMappings = this.mappings.get(index);
            boolean includeTypeName = params.paramAsBoolean("include_type_name", true);
            if (includeTypeName) {
                builder.startObject("mappings");
                if (indexMappings != null) {
                    for (ObjectObjectCursor<String, MappingMetaData> objectObjectCursor : indexMappings) {
                        builder.field((String)objectObjectCursor.key);
                        builder.map(((MappingMetaData)objectObjectCursor.value).sourceAsMap());
                    }
                }
                builder.endObject();
            } else {
                MappingMetaData mappings = null;
                for (ObjectObjectCursor<String, MappingMetaData> objectObjectCursor : indexMappings) {
                    if (((String)objectObjectCursor.key).equals("_default_")) continue;
                    assert (mappings == null);
                    mappings = (MappingMetaData)objectObjectCursor.value;
                }
                if (mappings == null) {
                    builder.startObject("mappings").endObject();
                } else {
                    builder.field("mappings", mappings.sourceAsMap());
                }
            }
            builder.startObject("settings");
            Settings indexSettings = this.settings.get(index);
            if (indexSettings != null) {
                indexSettings.toXContent(builder, params);
            }
            builder.endObject();
            Settings settings = this.defaultSettings.get(index);
            if (settings != null && !settings.isEmpty()) {
                builder.startObject("defaults");
                settings.toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    private static List<AliasMetaData> parseAliases(XContentParser parser) throws IOException {
        ArrayList<AliasMetaData> indexAliases = new ArrayList<AliasMetaData>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser::getTokenLocation);
            indexAliases.add(AliasMetaData.Builder.fromXContent(parser));
        }
        return indexAliases;
    }

    private static ImmutableOpenMap<String, MappingMetaData> parseMappings(XContentParser parser) throws IOException {
        ImmutableOpenMap.Builder<String, MappingMetaData> indexMappings = ImmutableOpenMap.builder();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser::getTokenLocation);
            parser.nextToken();
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                String mappingType = parser.currentName();
                indexMappings.put(mappingType, new MappingMetaData(mappingType, parser.map()));
                continue;
            }
            if (parser.currentToken() != XContentParser.Token.START_ARRAY) continue;
            parser.skipChildren();
        }
        return indexMappings.build();
    }

    private static IndexEntry parseIndexEntry(XContentParser parser) throws IOException {
        List<AliasMetaData> indexAliases = null;
        ImmutableOpenMap<String, MappingMetaData> indexMappings = null;
        Settings indexSettings = null;
        Settings indexDefaultSettings = null;
        block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser::getTokenLocation);
            parser.nextToken();
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                switch (parser.currentName()) {
                    case "aliases": {
                        indexAliases = GetIndexResponse.parseAliases(parser);
                        continue block12;
                    }
                    case "mappings": {
                        indexMappings = GetIndexResponse.parseMappings(parser);
                        continue block12;
                    }
                    case "settings": {
                        indexSettings = Settings.fromXContent(parser);
                        continue block12;
                    }
                    case "defaults": {
                        indexDefaultSettings = Settings.fromXContent(parser);
                        continue block12;
                    }
                }
                parser.skipChildren();
                continue;
            }
            if (parser.currentToken() != XContentParser.Token.START_ARRAY) continue;
            parser.skipChildren();
        }
        return new IndexEntry(indexAliases, indexMappings, indexSettings, indexDefaultSettings);
    }

    public static GetIndexResponse fromXContent(XContentParser parser) throws IOException {
        ImmutableOpenMap.Builder<String, List<AliasMetaData>> aliases = ImmutableOpenMap.builder();
        ImmutableOpenMap.Builder<String, ImmutableOpenMap<String, MappingMetaData>> mappings = ImmutableOpenMap.builder();
        ImmutableOpenMap.Builder<String, Settings> settings = ImmutableOpenMap.builder();
        ImmutableOpenMap.Builder<String, Settings> defaultSettings = ImmutableOpenMap.builder();
        ArrayList<String> indices = new ArrayList<String>();
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser::getTokenLocation);
        parser.nextToken();
        while (!parser.isClosed()) {
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                String indexName = parser.currentName();
                indices.add(indexName);
                IndexEntry indexEntry = GetIndexResponse.parseIndexEntry(parser);
                CollectionUtil.timSort(indexEntry.indexAliases, Comparator.comparing(AliasMetaData::alias));
                aliases.put(indexName, Collections.unmodifiableList(indexEntry.indexAliases));
                mappings.put(indexName, indexEntry.indexMappings);
                settings.put(indexName, indexEntry.indexSettings);
                if (indexEntry.indexDefaultSettings.isEmpty()) continue;
                defaultSettings.put(indexName, indexEntry.indexDefaultSettings);
                continue;
            }
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                parser.skipChildren();
                continue;
            }
            parser.nextToken();
        }
        return new GetIndexResponse(indices.toArray(new String[0]), mappings.build(), aliases.build(), settings.build(), defaultSettings.build());
    }

    public String toString() {
        return Strings.toString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetIndexResponse that = (GetIndexResponse)o;
        return Arrays.equals(this.indices, that.indices) && Objects.equals(this.aliases, that.aliases) && Objects.equals(this.mappings, that.mappings) && Objects.equals(this.settings, that.settings) && Objects.equals(this.defaultSettings, that.defaultSettings);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.indices), this.aliases, this.mappings, this.settings, this.defaultSettings);
    }

    private static class IndexEntry {
        List<AliasMetaData> indexAliases = new ArrayList<AliasMetaData>();
        ImmutableOpenMap<String, MappingMetaData> indexMappings = ImmutableOpenMap.of();
        Settings indexSettings = Settings.EMPTY;
        Settings indexDefaultSettings = Settings.EMPTY;

        IndexEntry(List<AliasMetaData> indexAliases, ImmutableOpenMap<String, MappingMetaData> indexMappings, Settings indexSettings, Settings indexDefaultSettings) {
            if (indexAliases != null) {
                this.indexAliases = indexAliases;
            }
            if (indexMappings != null) {
                this.indexMappings = indexMappings;
            }
            if (indexSettings != null) {
                this.indexSettings = indexSettings;
            }
            if (indexDefaultSettings != null) {
                this.indexDefaultSettings = indexDefaultSettings;
            }
        }
    }
}

