/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.ingest;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionRequestValidationException;
import conductor.org.elasticsearch.action.support.master.AcknowledgedRequest;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentHelper;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import java.io.IOException;
import java.util.Objects;

public class PutPipelineRequest
extends AcknowledgedRequest<PutPipelineRequest>
implements ToXContentObject {
    private String id;
    private BytesReference source;
    private XContentType xContentType;

    @Deprecated
    public PutPipelineRequest(String id, BytesReference source) {
        this(id, source, XContentHelper.xContentType(source));
    }

    public PutPipelineRequest(String id, BytesReference source, XContentType xContentType) {
        this.id = Objects.requireNonNull(id);
        this.source = Objects.requireNonNull(source);
        this.xContentType = Objects.requireNonNull(xContentType);
    }

    PutPipelineRequest() {
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public BytesReference getSource() {
        return this.source;
    }

    public XContentType getXContentType() {
        return this.xContentType;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readString();
        this.source = in.readBytesReference();
        this.xContentType = in.getVersion().onOrAfter(Version.V_5_3_0) ? in.readEnum(XContentType.class) : XContentHelper.xContentType(this.source);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        out.writeBytesReference(this.source);
        if (out.getVersion().onOrAfter(Version.V_5_3_0)) {
            out.writeEnum(this.xContentType);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.source != null) {
            builder.rawValue(this.source.streamInput(), this.xContentType);
        } else {
            builder.startObject().endObject();
        }
        return builder;
    }
}

