/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.support;

import conductor.org.elasticsearch.common.settings.ClusterSettings;
import conductor.org.elasticsearch.common.settings.Setting;
import conductor.org.elasticsearch.common.settings.Settings;

public final class DestructiveOperations {
    public static final Setting<Boolean> REQUIRES_NAME_SETTING = Setting.boolSetting("action.destructive_requires_name", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile boolean destructiveRequiresName;

    public DestructiveOperations(Settings settings, ClusterSettings clusterSettings) {
        this.destructiveRequiresName = REQUIRES_NAME_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(REQUIRES_NAME_SETTING, this::setDestructiveRequiresName);
    }

    private void setDestructiveRequiresName(boolean destructiveRequiresName) {
        this.destructiveRequiresName = destructiveRequiresName;
    }

    public void failDestructive(String[] aliasesOrIndices) {
        if (!this.destructiveRequiresName) {
            return;
        }
        if (aliasesOrIndices == null || aliasesOrIndices.length == 0) {
            throw new IllegalArgumentException("Wildcard expressions or all indices are not allowed");
        }
        if (aliasesOrIndices.length == 1) {
            if (DestructiveOperations.hasWildcardUsage(aliasesOrIndices[0])) {
                throw new IllegalArgumentException("Wildcard expressions or all indices are not allowed");
            }
        } else {
            for (String aliasesOrIndex : aliasesOrIndices) {
                if (!DestructiveOperations.hasWildcardUsage(aliasesOrIndex)) continue;
                throw new IllegalArgumentException("Wildcard expressions or all indices are not allowed");
            }
        }
    }

    private static boolean hasWildcardUsage(String aliasOrIndex) {
        return "_all".equals(aliasOrIndex) || aliasOrIndex.indexOf(42) != -1;
    }
}

