/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.update;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionRequestValidationException;
import conductor.org.elasticsearch.action.DocWriteRequest;
import conductor.org.elasticsearch.action.ValidateActions;
import conductor.org.elasticsearch.action.index.IndexRequest;
import conductor.org.elasticsearch.action.support.ActiveShardCount;
import conductor.org.elasticsearch.action.support.WriteRequest;
import conductor.org.elasticsearch.action.support.single.instance.InstanceShardOperationRequest;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.logging.DeprecationLogger;
import conductor.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentFactory;
import conductor.org.elasticsearch.common.xcontent.XContentHelper;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import conductor.org.elasticsearch.index.VersionType;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.script.Script;
import conductor.org.elasticsearch.script.ScriptType;
import conductor.org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateRequest
extends InstanceShardOperationRequest<UpdateRequest>
implements DocWriteRequest<UpdateRequest>,
WriteRequest<UpdateRequest>,
ToXContentObject {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(UpdateRequest.class));
    private String type;
    private String id;
    @Nullable
    private String routing;
    @Nullable
    private String parent;
    @Nullable
    Script script;
    private String[] fields;
    private FetchSourceContext fetchSourceContext;
    private long version = -3L;
    private VersionType versionType = VersionType.INTERNAL;
    private int retryOnConflict = 0;
    private long ifSeqNo = -2L;
    private long ifPrimaryTerm = 0L;
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.NONE;
    private ActiveShardCount waitForActiveShards = ActiveShardCount.DEFAULT;
    private IndexRequest upsertRequest;
    private boolean scriptedUpsert = false;
    private boolean docAsUpsert = false;
    private boolean detectNoop = true;
    @Nullable
    private IndexRequest doc;

    public UpdateRequest() {
    }

    public UpdateRequest(String index, String type, String id) {
        super(index);
        this.type = type;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.version != -3L && this.upsertRequest != null) {
            validationException = ValidateActions.addValidationError("can't provide both upsert request and a version", validationException);
        }
        if (this.upsertRequest != null && this.upsertRequest.version() != -3L) {
            validationException = ValidateActions.addValidationError("can't provide version in upsert request", validationException);
        }
        if (Strings.isEmpty(this.type)) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (Strings.isEmpty(this.id)) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        if (this.versionType != VersionType.INTERNAL) {
            validationException = ValidateActions.addValidationError("version type [" + this.versionType + "] is not supported by the update API", validationException);
        } else {
            if (this.version != -3L && this.retryOnConflict > 0) {
                validationException = ValidateActions.addValidationError("can't provide both retry_on_conflict and a specific version", validationException);
            }
            if (!this.versionType.validateVersionForWrites(this.version)) {
                validationException = ValidateActions.addValidationError("illegal version value [" + this.version + "] for version type [" + this.versionType.name() + "]", validationException);
            }
        }
        validationException = DocWriteRequest.validateSeqNoBasedCASParams(this, validationException);
        if (this.ifSeqNo != -2L && this.retryOnConflict > 0) {
            validationException = ValidateActions.addValidationError("compare and write operations can not be retried", validationException);
        }
        if (this.ifSeqNo != -2L && this.docAsUpsert) {
            validationException = ValidateActions.addValidationError("compare and write operations can not be used with upsert", validationException);
        }
        if (this.script == null && this.doc == null) {
            validationException = ValidateActions.addValidationError("script or doc is missing", validationException);
        }
        if (this.script != null && this.doc != null) {
            validationException = ValidateActions.addValidationError("can't provide both script and doc", validationException);
        }
        if (this.doc == null && this.docAsUpsert) {
            validationException = ValidateActions.addValidationError("doc must be specified if doc_as_upsert is enabled", validationException);
        }
        return validationException;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public UpdateRequest type(String type) {
        this.type = type;
        return this;
    }

    @Override
    public String id() {
        return this.id;
    }

    public UpdateRequest id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public UpdateRequest routing(String routing) {
        this.routing = routing != null && routing.length() == 0 ? null : routing;
        return this;
    }

    @Override
    public String routing() {
        return this.routing;
    }

    public UpdateRequest parent(String parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public String parent() {
        return this.parent;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public Script script() {
        return this.script;
    }

    public UpdateRequest script(Script script) {
        this.script = script;
        return this;
    }

    @Deprecated
    public String scriptString() {
        return this.script == null ? null : this.script.getIdOrCode();
    }

    @Deprecated
    public ScriptType scriptType() {
        return this.script == null ? null : this.script.getType();
    }

    @Deprecated
    public Map<String, Object> scriptParams() {
        return this.script == null ? null : this.script.getParams();
    }

    @Deprecated
    public UpdateRequest script(String script, ScriptType scriptType) {
        this.updateOrCreateScript(script, scriptType, null, null);
        return this;
    }

    @Deprecated
    public UpdateRequest script(String script) {
        this.updateOrCreateScript(script, ScriptType.INLINE, null, null);
        return this;
    }

    @Deprecated
    public UpdateRequest scriptLang(String scriptLang) {
        this.updateOrCreateScript(null, null, scriptLang, null);
        return this;
    }

    @Deprecated
    public String scriptLang() {
        return this.script == null ? null : this.script.getLang();
    }

    @Deprecated
    public UpdateRequest addScriptParam(String name, Object value) {
        Script script = this.script();
        if (script == null) {
            HashMap<String, Object> scriptParams = new HashMap<String, Object>();
            scriptParams.put(name, value);
            this.updateOrCreateScript(null, null, null, scriptParams);
        } else {
            Map<String, Object> scriptParams = script.getParams();
            if (scriptParams == null) {
                scriptParams = new HashMap<String, Object>();
                scriptParams.put(name, value);
                this.updateOrCreateScript(null, null, null, scriptParams);
            } else {
                scriptParams.put(name, value);
            }
        }
        return this;
    }

    @Deprecated
    public UpdateRequest scriptParams(Map<String, Object> scriptParams) {
        this.updateOrCreateScript(null, null, null, scriptParams);
        return this;
    }

    private void updateOrCreateScript(String scriptContent, ScriptType type, String lang, Map<String, Object> params) {
        Script script = this.script();
        if (script == null) {
            script = new Script(type == null ? ScriptType.INLINE : type, lang, scriptContent == null ? "" : scriptContent, params);
        } else {
            String newScriptContent = scriptContent == null ? script.getIdOrCode() : scriptContent;
            ScriptType newScriptType = type == null ? script.getType() : type;
            String newScriptLang = lang == null ? script.getLang() : lang;
            Map<String, Object> newScriptParams = params == null ? script.getParams() : params;
            script = new Script(newScriptType, newScriptLang, newScriptContent, newScriptParams);
        }
        this.script(script);
    }

    @Deprecated
    public UpdateRequest script(String script, ScriptType scriptType, @Nullable Map<String, Object> scriptParams) {
        this.script = new Script(scriptType, "painless", script, scriptParams);
        return this;
    }

    @Deprecated
    public UpdateRequest script(String script, @Nullable String scriptLang, ScriptType scriptType, @Nullable Map<String, Object> scriptParams) {
        this.script = new Script(scriptType, scriptLang, script, scriptParams);
        return this;
    }

    @Deprecated
    public UpdateRequest fields(String ... fields) {
        this.fields = fields;
        return this;
    }

    public UpdateRequest fetchSource(@Nullable String include, @Nullable String exclude) {
        String[] stringArray;
        String[] stringArray2;
        FetchSourceContext context;
        FetchSourceContext fetchSourceContext = context = this.fetchSourceContext == null ? FetchSourceContext.FETCH_SOURCE : this.fetchSourceContext;
        if (include == null) {
            stringArray2 = Strings.EMPTY_ARRAY;
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = include;
        }
        String[] includes = stringArray2;
        if (exclude == null) {
            stringArray = Strings.EMPTY_ARRAY;
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = exclude;
        }
        String[] excludes = stringArray;
        this.fetchSourceContext = new FetchSourceContext(context.fetchSource(), includes, excludes);
        return this;
    }

    public UpdateRequest fetchSource(@Nullable String[] includes, @Nullable String[] excludes) {
        FetchSourceContext context = this.fetchSourceContext == null ? FetchSourceContext.FETCH_SOURCE : this.fetchSourceContext;
        this.fetchSourceContext = new FetchSourceContext(context.fetchSource(), includes, excludes);
        return this;
    }

    public UpdateRequest fetchSource(boolean fetchSource) {
        FetchSourceContext context = this.fetchSourceContext == null ? FetchSourceContext.FETCH_SOURCE : this.fetchSourceContext;
        this.fetchSourceContext = new FetchSourceContext(fetchSource, context.includes(), context.excludes());
        return this;
    }

    public UpdateRequest fetchSource(FetchSourceContext context) {
        this.fetchSourceContext = context;
        return this;
    }

    @Deprecated
    public String[] fields() {
        return this.fields;
    }

    public FetchSourceContext fetchSource() {
        return this.fetchSourceContext;
    }

    public UpdateRequest retryOnConflict(int retryOnConflict) {
        this.retryOnConflict = retryOnConflict;
        return this;
    }

    public int retryOnConflict() {
        return this.retryOnConflict;
    }

    @Override
    public UpdateRequest version(long version) {
        this.version = version;
        return this;
    }

    @Override
    public long version() {
        return this.version;
    }

    @Override
    public UpdateRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    @Override
    public VersionType versionType() {
        return this.versionType;
    }

    @Override
    public UpdateRequest setIfSeqNo(long seqNo) {
        if (seqNo < 0L && seqNo != -2L) {
            throw new IllegalArgumentException("sequence numbers must be non negative. got [" + seqNo + "].");
        }
        this.ifSeqNo = seqNo;
        return this;
    }

    @Override
    public UpdateRequest setIfPrimaryTerm(long term) {
        if (term < 0L) {
            throw new IllegalArgumentException("primary term must be non negative. got [" + term + "]");
        }
        this.ifPrimaryTerm = term;
        return this;
    }

    @Override
    public long ifSeqNo() {
        return this.ifSeqNo;
    }

    @Override
    public long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    @Override
    public DocWriteRequest.OpType opType() {
        return DocWriteRequest.OpType.UPDATE;
    }

    @Override
    public UpdateRequest setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return this;
    }

    @Override
    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public UpdateRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    public UpdateRequest waitForActiveShards(int waitForActiveShards) {
        return this.waitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public UpdateRequest doc(IndexRequest doc) {
        this.doc = doc;
        return this;
    }

    public UpdateRequest doc(XContentBuilder source) {
        this.safeDoc().source(source);
        return this;
    }

    public UpdateRequest doc(Map source) {
        this.safeDoc().source(source);
        return this;
    }

    public UpdateRequest doc(Map source, XContentType contentType) {
        this.safeDoc().source(source, contentType);
        return this;
    }

    public UpdateRequest doc(String source, XContentType xContentType) {
        this.safeDoc().source(source, xContentType);
        return this;
    }

    public UpdateRequest doc(byte[] source, XContentType xContentType) {
        this.safeDoc().source(source, xContentType);
        return this;
    }

    public UpdateRequest doc(byte[] source, int offset, int length, XContentType xContentType) {
        this.safeDoc().source(source, offset, length, xContentType);
        return this;
    }

    public UpdateRequest doc(Object ... source) {
        this.safeDoc().source(source);
        return this;
    }

    public UpdateRequest doc(XContentType xContentType, Object ... source) {
        this.safeDoc().source(xContentType, source);
        return this;
    }

    public IndexRequest doc() {
        return this.doc;
    }

    private IndexRequest safeDoc() {
        if (this.doc == null) {
            this.doc = new IndexRequest();
        }
        return this.doc;
    }

    public UpdateRequest upsert(IndexRequest upsertRequest) {
        this.upsertRequest = upsertRequest;
        return this;
    }

    public UpdateRequest upsert(XContentBuilder source) {
        this.safeUpsertRequest().source(source);
        return this;
    }

    public UpdateRequest upsert(Map source) {
        this.safeUpsertRequest().source(source);
        return this;
    }

    public UpdateRequest upsert(Map source, XContentType contentType) {
        this.safeUpsertRequest().source(source, contentType);
        return this;
    }

    public UpdateRequest upsert(String source, XContentType xContentType) {
        this.safeUpsertRequest().source(source, xContentType);
        return this;
    }

    public UpdateRequest upsert(byte[] source, XContentType xContentType) {
        this.safeUpsertRequest().source(source, xContentType);
        return this;
    }

    public UpdateRequest upsert(byte[] source, int offset, int length, XContentType xContentType) {
        this.safeUpsertRequest().source(source, offset, length, xContentType);
        return this;
    }

    public UpdateRequest upsert(Object ... source) {
        this.safeUpsertRequest().source(source);
        return this;
    }

    public UpdateRequest upsert(XContentType xContentType, Object ... source) {
        this.safeUpsertRequest().source(xContentType, source);
        return this;
    }

    public IndexRequest upsertRequest() {
        return this.upsertRequest;
    }

    private IndexRequest safeUpsertRequest() {
        if (this.upsertRequest == null) {
            this.upsertRequest = new IndexRequest();
        }
        return this.upsertRequest;
    }

    public UpdateRequest detectNoop(boolean detectNoop) {
        this.detectNoop = detectNoop;
        return this;
    }

    public boolean detectNoop() {
        return this.detectNoop;
    }

    public UpdateRequest fromXContent(XContentParser parser) throws IOException {
        Script script = null;
        XContentParser.Token token = parser.nextToken();
        if (token == null) {
            return this;
        }
        String currentFieldName = null;
        int depth = 0;
        while (token != null) {
            token = parser.nextToken();
            if (token == XContentParser.Token.START_OBJECT) {
                ++depth;
            } else if (token == XContentParser.Token.END_OBJECT) {
                currentFieldName = null;
                if (depth == 0) break;
                --depth;
                continue;
            }
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
            } else if ("script".equals(currentFieldName)) {
                script = Script.parse(parser);
            } else if ("if_seq_no".equals(currentFieldName)) {
                this.setIfSeqNo(parser.longValue());
            } else if ("if_primary_term".equals(currentFieldName)) {
                this.setIfPrimaryTerm(parser.longValue());
            } else if ("scripted_upsert".equals(currentFieldName)) {
                this.scriptedUpsert = parser.booleanValue();
            } else if ("upsert".equals(currentFieldName)) {
                XContentBuilder builder = XContentFactory.contentBuilder(parser.contentType());
                builder.copyCurrentStructure(parser);
                this.safeUpsertRequest().source(builder);
            } else if ("doc".equals(currentFieldName)) {
                XContentBuilder docBuilder = XContentFactory.contentBuilder(parser.contentType());
                docBuilder.copyCurrentStructure(parser);
                this.safeDoc().source(docBuilder);
            } else if ("doc_as_upsert".equals(currentFieldName)) {
                this.docAsUpsert(parser.booleanValue());
            } else if ("detect_noop".equals(currentFieldName)) {
                this.detectNoop(parser.booleanValue());
            } else if ("fields".equals(currentFieldName)) {
                DEPRECATION_LOGGER.deprecated("Deprecated field [fields] used, expected [_source] instead", new Object[0]);
                List<Object> fields = null;
                if (token == XContentParser.Token.START_ARRAY) {
                    fields = parser.list();
                } else if (token.isValue()) {
                    fields = Collections.singletonList(parser.text());
                }
                if (fields != null) {
                    this.fields(fields.toArray(new String[fields.size()]));
                }
            } else if ("_source".equals(currentFieldName)) {
                this.fetchSourceContext = FetchSourceContext.fromXContent(parser);
            } else {
                DEPRECATION_LOGGER.deprecated("Unknown field [{}] used in {} which has no value and will not be accepted in future", currentFieldName, UpdateRequest.class.getSimpleName());
            }
            if (parser.currentToken() != XContentParser.Token.END_OBJECT) continue;
            --depth;
        }
        if (script != null) {
            this.script = script;
        }
        return this;
    }

    public boolean docAsUpsert() {
        return this.docAsUpsert;
    }

    public UpdateRequest docAsUpsert(boolean shouldUpsertDoc) {
        this.docAsUpsert = shouldUpsertDoc;
        return this;
    }

    public boolean scriptedUpsert() {
        return this.scriptedUpsert;
    }

    public UpdateRequest scriptedUpsert(boolean scriptedUpsert) {
        this.scriptedUpsert = scriptedUpsert;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.waitForActiveShards = ActiveShardCount.readFrom(in);
        this.type = in.readString();
        this.id = in.readString();
        this.routing = in.readOptionalString();
        this.parent = in.readOptionalString();
        if (in.readBoolean()) {
            this.script = new Script(in);
        }
        this.retryOnConflict = in.readVInt();
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom(in);
        if (in.readBoolean()) {
            this.doc = new IndexRequest();
            this.doc.readFrom(in);
        }
        this.fields = in.readOptionalStringArray();
        this.fetchSourceContext = in.readOptionalWriteable(FetchSourceContext::new);
        if (in.readBoolean()) {
            this.upsertRequest = new IndexRequest();
            this.upsertRequest.readFrom(in);
        }
        this.docAsUpsert = in.readBoolean();
        this.version = in.readLong();
        this.versionType = VersionType.fromValue(in.readByte());
        if (in.getVersion().onOrAfter(Version.V_6_7_0)) {
            this.ifSeqNo = in.readZLong();
            this.ifPrimaryTerm = in.readVLong();
        }
        this.detectNoop = in.readBoolean();
        this.scriptedUpsert = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.waitForActiveShards.writeTo(out);
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.parent);
        boolean hasScript = this.script != null;
        out.writeBoolean(hasScript);
        if (hasScript) {
            this.script.writeTo(out);
        }
        out.writeVInt(this.retryOnConflict);
        this.refreshPolicy.writeTo(out);
        if (this.doc == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.doc.index(this.index);
            this.doc.type(this.type);
            this.doc.id(this.id);
            this.doc.writeTo(out);
        }
        out.writeOptionalStringArray(this.fields);
        out.writeOptionalWriteable(this.fetchSourceContext);
        if (this.upsertRequest == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.upsertRequest.index(this.index);
            this.upsertRequest.type(this.type);
            this.upsertRequest.id(this.id);
            this.upsertRequest.writeTo(out);
        }
        out.writeBoolean(this.docAsUpsert);
        out.writeLong(this.version);
        out.writeByte(this.versionType.getValue());
        if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
            out.writeZLong(this.ifSeqNo);
            out.writeVLong(this.ifPrimaryTerm);
        }
        out.writeBoolean(this.detectNoop);
        out.writeBoolean(this.scriptedUpsert);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentParser parser;
        XContentType xContentType;
        builder.startObject();
        if (this.docAsUpsert) {
            builder.field("doc_as_upsert", this.docAsUpsert);
        }
        if (this.doc != null) {
            xContentType = this.doc.getContentType();
            parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, this.doc.source(), xContentType);
            try {
                builder.field("doc");
                builder.copyCurrentStructure(parser);
            }
            finally {
                if (parser != null) {
                    parser.close();
                }
            }
        }
        if (this.ifSeqNo != -2L) {
            builder.field("if_seq_no", this.ifSeqNo);
            builder.field("if_primary_term", this.ifPrimaryTerm);
        }
        if (this.script != null) {
            builder.field("script", this.script);
        }
        if (this.upsertRequest != null) {
            xContentType = this.upsertRequest.getContentType();
            parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, this.upsertRequest.source(), xContentType);
            try {
                builder.field("upsert");
                builder.copyCurrentStructure(parser);
            }
            finally {
                if (parser != null) {
                    parser.close();
                }
            }
        }
        if (this.scriptedUpsert) {
            builder.field("scripted_upsert", this.scriptedUpsert);
        }
        if (!this.detectNoop) {
            builder.field("detect_noop", this.detectNoop);
        }
        if (this.fields != null) {
            builder.array("fields", this.fields);
        }
        if (this.fetchSourceContext != null) {
            builder.field("_source", this.fetchSourceContext);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        StringBuilder res = new StringBuilder().append("update {[").append(this.index).append("][").append(this.type).append("][").append(this.id).append("]");
        res.append(", doc_as_upsert[").append(this.docAsUpsert).append("]");
        if (this.doc != null) {
            res.append(", doc[").append(this.doc).append("]");
        }
        if (this.script != null) {
            res.append(", script[").append(this.script).append("]");
        }
        if (this.upsertRequest != null) {
            res.append(", upsert[").append(this.upsertRequest).append("]");
        }
        res.append(", scripted_upsert[").append(this.scriptedUpsert).append("]");
        res.append(", detect_noop[").append(this.detectNoop).append("]");
        if (this.fields != null) {
            res.append(", fields[").append(Arrays.toString(this.fields)).append("]");
        }
        return res.append("}").toString();
    }
}

