/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.watcher;

import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentFactory;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import conductor.org.elasticsearch.common.xcontent.XContentUtils;
import java.io.IOException;
import java.util.Map;

public class ExecuteWatchResponse {
    public static final ParseField ID_FIELD = new ParseField("_id", new String[0]);
    public static final ParseField WATCH_FIELD = new ParseField("watch_record", new String[0]);
    private String recordId;
    private BytesReference contentSource;
    private Map<String, Object> data;
    private static final ConstructingObjectParser<ExecuteWatchResponse, Void> PARSER = new ConstructingObjectParser("x_pack_execute_watch_response", true, fields -> new ExecuteWatchResponse((String)fields[0], (BytesReference)fields[1]));

    public ExecuteWatchResponse() {
    }

    public ExecuteWatchResponse(String recordId, BytesReference contentSource) {
        this.recordId = recordId;
        this.contentSource = contentSource;
    }

    public String getRecordId() {
        return this.recordId;
    }

    public BytesReference getRecord() {
        return this.contentSource;
    }

    public Map<String, Object> getRecordAsMap() {
        if (this.data == null) {
            try (StreamInput stream = this.contentSource.streamInput();
                 XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, null, stream);){
                this.data = (Map)XContentUtils.readValue(parser, parser.nextToken());
            }
            catch (IOException ex) {
                throw new ElasticsearchException("failed to read value", (Throwable)ex, new Object[0]);
            }
        }
        return this.data;
    }

    public static ExecuteWatchResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    private static BytesReference readBytesReference(XContentParser parser) throws IOException {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.copyCurrentStructure(parser);
            BytesReference bytesReference = BytesReference.bytes(builder);
            return bytesReference;
        }
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ID_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ExecuteWatchResponse.readBytesReference(p), WATCH_FIELD);
    }
}

