/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.inject.spi;

import conductor.org.elasticsearch.common.inject.Binder;
import conductor.org.elasticsearch.common.inject.Key;
import conductor.org.elasticsearch.common.inject.Provider;
import conductor.org.elasticsearch.common.inject.spi.Element;
import conductor.org.elasticsearch.common.inject.spi.ElementVisitor;
import java.util.Objects;

public final class ProviderLookup<T>
implements Element {
    private final Object source;
    private final Key<T> key;
    private Provider<T> delegate;

    public ProviderLookup(Object source, Key<T> key) {
        this.source = Objects.requireNonNull(source, "source");
        this.key = Objects.requireNonNull(key, "key");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Key<T> getKey() {
        return this.key;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public void initializeDelegate(Provider<T> delegate) {
        if (this.delegate != null) {
            throw new IllegalStateException("delegate already initialized");
        }
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    @Override
    public void applyTo(Binder binder) {
        this.initializeDelegate(binder.withSource(this.getSource()).getProvider(this.key));
    }

    public Provider<T> getDelegate() {
        return this.delegate;
    }

    public Provider<T> getProvider() {
        return new ProviderImpl(this);
    }

    public static class ProviderImpl<T>
    implements Provider<T> {
        private ProviderLookup<T> lookup;

        private ProviderImpl(ProviderLookup<T> lookup) {
            this.lookup = lookup;
        }

        @Override
        public T get() {
            if (((ProviderLookup)this.lookup).delegate == null) {
                throw new IllegalStateException("This Provider cannot be used until the Injector has been created.");
            }
            return ((ProviderLookup)this.lookup).delegate.get();
        }

        public String toString() {
            return "Provider<" + ((ProviderLookup)this.lookup).key.getTypeLiteral() + ">";
        }

        public Key<T> getKey() {
            return this.lookup.getKey();
        }
    }
}

