/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Objects;

final class DerParser {
    private static final int CONSTRUCTED = 32;
    private static final int INTEGER = 2;
    private static final int OCTET_STRING = 4;
    private static final int OBJECT_OID = 6;
    private static final int NUMERIC_STRING = 18;
    private static final int PRINTABLE_STRING = 19;
    private static final int VIDEOTEX_STRING = 21;
    private static final int IA5_STRING = 22;
    private static final int GRAPHIC_STRING = 25;
    private static final int ISO646_STRING = 26;
    private static final int GENERAL_STRING = 27;
    private static final int UTF8_STRING = 12;
    private static final int UNIVERSAL_STRING = 28;
    private static final int BMP_STRING = 30;
    private InputStream derInputStream;
    private int maxAsnObjectLength;
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    DerParser(byte[] bytes) {
        this.derInputStream = new ByteArrayInputStream(bytes);
        this.maxAsnObjectLength = bytes.length;
    }

    Asn1Object readAsn1Object() throws IOException {
        int tag = this.derInputStream.read();
        if (tag == -1) {
            throw new IOException("Invalid DER: stream too short, missing tag");
        }
        int length = this.getLength();
        if (length > this.maxAsnObjectLength) {
            throw new IOException("Invalid DER: size of ASN.1 object to be parsed appears to be larger than the size of the key file itself.");
        }
        byte[] value = new byte[length];
        int n = this.derInputStream.read(value);
        if (n < length) {
            throw new IOException("Invalid DER: stream too short, missing value. Could only read " + n + " out of " + length + " bytes");
        }
        return new Asn1Object(tag, length, value);
    }

    private int getLength() throws IOException {
        int i = this.derInputStream.read();
        if (i == -1) {
            throw new IOException("Invalid DER: length missing");
        }
        if ((i & 0xFFFFFF80) == 0) {
            return i;
        }
        int num = i & 0x7F;
        if (i >= 255 || num > 4) {
            throw new IOException("Invalid DER: length field too big (" + i + ")");
        }
        byte[] bytes = new byte[num];
        int n = this.derInputStream.read(bytes);
        if (n < num) {
            throw new IOException("Invalid DER: length too short");
        }
        return new BigInteger(1, bytes).intValue();
    }

    private static String toHexString(byte[] bytes) {
        Objects.requireNonNull(bytes);
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            sb.append(HEX_DIGITS[b >> 4 & 0xF]).append(HEX_DIGITS[b & 0xF]);
        }
        return sb.toString();
    }

    static class Asn1Object {
        protected final int type;
        protected final int length;
        protected final byte[] value;
        protected final int tag;

        Asn1Object(int tag, int length, byte[] value) {
            this.tag = tag;
            this.type = tag & 0x1F;
            this.length = length;
            this.value = value;
        }

        public int getType() {
            return this.type;
        }

        public int getLength() {
            return this.length;
        }

        public byte[] getValue() {
            return this.value;
        }

        public boolean isConstructed() {
            return (this.tag & 0x20) == 32;
        }

        public DerParser getParser() throws IOException {
            if (!this.isConstructed()) {
                throw new IOException("Invalid DER: can't parse primitive entity");
            }
            return new DerParser(this.value);
        }

        public BigInteger getInteger() throws IOException {
            if (this.type != 2) {
                throw new IOException("Invalid DER: object is not integer");
            }
            return new BigInteger(this.value);
        }

        public String getString() throws IOException {
            String encoding;
            switch (this.type) {
                case 4: {
                    return DerParser.toHexString(this.value);
                }
                case 18: 
                case 19: 
                case 21: 
                case 22: 
                case 25: 
                case 26: 
                case 27: {
                    encoding = "ISO-8859-1";
                    break;
                }
                case 30: {
                    encoding = "UTF-16BE";
                    break;
                }
                case 12: {
                    encoding = "UTF-8";
                    break;
                }
                case 28: {
                    throw new IOException("Invalid DER: can't handle UCS-4 string");
                }
                default: {
                    throw new IOException("Invalid DER: object is not a string");
                }
            }
            return new String(this.value, encoding);
        }

        public String getOid() throws IOException {
            if (this.type != 6) {
                throw new IOException("Ivalid DER: object is not object OID");
            }
            StringBuilder sb = new StringBuilder(64);
            switch (this.value[0] / 40) {
                case 0: {
                    sb.append('0');
                    break;
                }
                case 1: {
                    sb.append('1');
                    this.value[0] = (byte)(this.value[0] - 40);
                    break;
                }
                default: {
                    sb.append('2');
                    this.value[0] = (byte)(this.value[0] - 80);
                }
            }
            int oidPart = 0;
            for (int i = 0; i < this.length; ++i) {
                oidPart = (oidPart << 7) + (this.value[i] & 0x7F);
                if ((this.value[i] & 0x80) != 0) continue;
                sb.append('.');
                sb.append(oidPart);
                oidPart = 0;
            }
            return sb.toString();
        }
    }
}

